/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.AbstractBindingInfoFactoryBean;
import org.apache.cxf.service.factory.MethodDispatcher;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.codehaus.jra.Delete;
import org.codehaus.jra.Get;
import org.codehaus.jra.HttpResource;
import org.codehaus.jra.Post;
import org.codehaus.jra.Put;

public class HttpBindingInfoFactoryBean
extends AbstractBindingInfoFactoryBean {
    private URIMapper mapper = new URIMapper();

    public BindingInfo create() {
        BindingInfo info = new BindingInfo(this.getServiceInfo(), "http://apache.org/cxf/binding/http");
        info.setName(new QName(this.getServiceInfo().getName().getNamespaceURI(), this.getServiceInfo().getName().getLocalPart() + "HttpBinding"));
        ReflectionServiceFactoryBean sf = (ReflectionServiceFactoryBean)this.getServiceFactory();
        Service service = sf.getService();
        MethodDispatcher md = (MethodDispatcher)service.get((Object)MethodDispatcher.class.getName());
        for (OperationInfo o : this.getServiceInfo().getInterface().getOperations()) {
            BindingOperationInfo bop = info.buildOperation(o.getName(), o.getInputName(), o.getOutputName());
            info.addOperation(bop);
            Method m = md.getMethod(bop);
            HttpResource r = m.getAnnotation(HttpResource.class);
            if (r == null) continue;
            String verb = m.isAnnotationPresent(Get.class) ? "GET" : (m.isAnnotationPresent(Post.class) ? "POST" : (m.isAnnotationPresent(Put.class) ? "PUT" : (m.isAnnotationPresent(Delete.class) ? "DELETE" : "GET")));
            this.mapper.bind(bop, r.location(), verb);
        }
        service.put((Object)URIMapper.class.getName(), (Object)this.mapper);
        return info;
    }
}

