/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing;

import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.RelatesToType;

public class AddressingPropertiesImpl
implements AddressingProperties {
    private AttributedURIType to;
    private AttributedURIType messageID;
    private EndpointReferenceType replyTo;
    private EndpointReferenceType faultTo;
    private RelatesToType relatesTo;
    private AttributedURIType action;
    private String namespaceURI;

    public AddressingPropertiesImpl() {
        this("http://www.w3.org/2005/08/addressing");
    }

    public AddressingPropertiesImpl(String uri) {
        this.namespaceURI = uri;
    }

    public AttributedURIType getTo() {
        return this.to;
    }

    public void setTo(AttributedURIType iri) {
        this.to = iri;
    }

    public AttributedURIType getMessageID() {
        return this.messageID;
    }

    public void setMessageID(AttributedURIType iri) {
        this.messageID = iri;
    }

    public EndpointReferenceType getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EndpointReferenceType ref) {
        this.replyTo = ref;
    }

    public EndpointReferenceType getFaultTo() {
        return this.faultTo;
    }

    public void setFaultTo(EndpointReferenceType ref) {
        this.faultTo = ref;
    }

    public RelatesToType getRelatesTo() {
        return this.relatesTo;
    }

    public void setRelatesTo(RelatesToType rel) {
        this.relatesTo = rel;
    }

    public AttributedURIType getAction() {
        return this.action;
    }

    public void setAction(AttributedURIType iri) {
        this.action = iri;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public void exposeAs(String uri) {
        this.namespaceURI = uri;
    }

    public String toString() {
        AttributedURIType address;
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        if (null != this.messageID) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("MessageId: ");
            buf.append(this.messageID.getValue());
        }
        if (null != this.action) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("Action: ");
            buf.append(this.action.getValue());
        }
        if (null != this.to) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("To: ");
            buf.append(this.to.getValue());
        }
        if (null != this.replyTo && null != (address = this.replyTo.getAddress())) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("ReplyTo: ");
            buf.append(address.getValue());
        }
        if (null != this.faultTo && null != (address = this.faultTo.getAddress())) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append("FaultTo: ");
            buf.append(address.getValue());
        }
        buf.append("]");
        return buf.toString();
    }
}

