/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.WSAContextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MAPAggregator
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(MAPAggregator.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();
    protected final Map<String, String> messageIDs = new HashMap<String, String>();
    private final AtomicBoolean usingAddressingDetermined = new AtomicBoolean(false);
    private final AtomicBoolean usingAddressing = new AtomicBoolean(false);
    private final boolean allowDuplicates = true;

    public MAPAggregator() {
        this.setPhase("pre-logical");
    }

    public void handleMessage(Message message) {
        this.mediate(message, ContextUtils.isFault(message));
    }

    public void handleFault(Message message) {
    }

    private boolean usingAddressing(Message message) {
        boolean ret = false;
        if (ContextUtils.isRequestor(message)) {
            if (!this.usingAddressingDetermined.get()) {
                Endpoint endpoint = (Endpoint)message.getExchange().get(Endpoint.class);
                if (endpoint != null) {
                    EndpointInfo endpointInfo = endpoint.getEndpointInfo();
                    List endpointExts = endpointInfo != null ? endpointInfo.getExtensors(ExtensibilityElement.class) : null;
                    List bindingExts = endpointInfo != null && endpointInfo.getBinding() != null ? endpointInfo.getBinding().getExtensors(ExtensibilityElement.class) : null;
                    List serviceExts = endpointInfo != null && endpointInfo.getService() != null ? endpointInfo.getService().getExtensors(ExtensibilityElement.class) : null;
                    ret = this.hasUsingAddressing(endpointExts) || this.hasUsingAddressing(bindingExts) || this.hasUsingAddressing(serviceExts);
                } else {
                    ret = WSAContextUtils.retrieveUsingAddressing((Message)message);
                }
                this.setUsingAddressing(ret);
            } else {
                ret = this.usingAddressing.get();
            }
        } else {
            ret = this.getMAPs(message, false, false) != null;
        }
        return ret;
    }

    private boolean hasUsingAddressing(List<ExtensibilityElement> exts) {
        boolean found = false;
        if (exts != null) {
            Iterator<ExtensibilityElement> extensionElements = exts.iterator();
            while (extensionElements.hasNext() && !found) {
                ExtensibilityElement ext = extensionElements.next();
                found = Names.WSAW_USING_ADDRESSING_QNAME.equals(ext.getElementType());
            }
        }
        return found;
    }

    protected boolean mediate(Message message, boolean isFault) {
        boolean continueProcessing = true;
        if (ContextUtils.isOutbound(message)) {
            if (this.usingAddressing(message)) {
                this.aggregate(message, isFault);
            }
        } else if (!ContextUtils.isRequestor(message)) {
            AddressingPropertiesImpl maps = this.getMAPs(message, false, false);
            this.setUsingAddressing(true);
            boolean isOneway = message.getExchange().isOneWay();
            continueProcessing = this.validateIncomingMAPs(maps, message);
            if (continueProcessing) {
                if (isOneway || !ContextUtils.isGenericAddress(maps.getReplyTo())) {
                    ContextUtils.rebaseResponse(maps.getReplyTo(), maps, message);
                }
            } else {
                this.aggregate(message, isFault);
            }
        }
        return continueProcessing;
    }

    private void aggregate(Message message, boolean isFault) {
        AddressingPropertiesImpl maps = this.assembleGeneric(message);
        boolean isRequestor = ContextUtils.isRequestor(message);
        this.addRoleSpecific(maps, message, isRequestor, isFault);
        ContextUtils.storeMAPs(maps, message, true, isRequestor);
    }

    private AddressingPropertiesImpl assembleGeneric(Message message) {
        AddressingPropertiesImpl maps = this.getMAPs(message, true, true);
        if (maps.getMessageID() == null) {
            String messageID = ContextUtils.generateUUID();
            maps.setMessageID(ContextUtils.getAttributedURI(messageID));
        }
        if (ContextUtils.hasEmptyAction(maps)) {
            maps.setAction(ContextUtils.getAction(message));
        }
        return maps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addRoleSpecific(AddressingPropertiesImpl maps, Message message, boolean isRequestor, boolean isFault) {
        if (isRequestor) {
            EndpointReferenceType replyTo;
            Exchange exchange = message.getExchange();
            boolean isOneway = exchange.isOneWay();
            boolean isOutbound = ContextUtils.isOutbound(message);
            Conduit conduit = null;
            if (maps.getTo() == null) {
                if (isOutbound) {
                    conduit = ContextUtils.getConduit(conduit, message);
                }
                EndpointReferenceType reference = conduit != null ? conduit.getTarget() : null;
                maps.setTo(reference != null ? reference.getAddress() : ContextUtils.getAttributedURI("http://www.w3.org/2005/08/addressing/none"));
            }
            if (ContextUtils.isGenericAddress(replyTo = maps.getReplyTo())) {
                Destination backChannel;
                if ((conduit = ContextUtils.getConduit(conduit, message)) != null && (backChannel = conduit.getBackChannel()) != null) {
                    replyTo = backChannel.getAddress();
                }
                if (replyTo == null || isOneway) {
                    AttributedURIType address = ContextUtils.getAttributedURI(isOneway ? "http://www.w3.org/2005/08/addressing/none" : "http://www.w3.org/2005/08/addressing/anonymous");
                    replyTo = ContextUtils.WSA_OBJECT_FACTORY.createEndpointReferenceType();
                    replyTo.setAddress(address);
                }
                maps.setReplyTo(replyTo);
            }
            if (isOneway) return;
        }
        AddressingPropertiesImpl inMAPs = this.getMAPs(message, false, false);
        maps.exposeAs(inMAPs.getNamespaceURI());
        if (maps.getTo() == null && inMAPs.getReplyTo() != null) {
            maps.setTo(inMAPs.getReplyTo().getAddress());
        }
        if (inMAPs.getMessageID() != null) {
            String inMessageID = inMAPs.getMessageID().getValue();
            maps.setRelatesTo(ContextUtils.getRelatesTo(inMessageID));
        }
        if (!isFault || ContextUtils.isGenericAddress(inMAPs.getFaultTo())) return;
        ContextUtils.rebaseResponse(inMAPs.getFaultTo(), inMAPs, message);
    }

    private AddressingPropertiesImpl getMAPs(Message message, boolean isProviderContext, boolean isOutbound) {
        AddressingPropertiesImpl maps = null;
        maps = ContextUtils.retrieveMAPs(message, isProviderContext, isOutbound);
        LOG.log(Level.INFO, "MAPs retrieved from message {0}", maps);
        if (maps == null && isProviderContext) {
            maps = new AddressingPropertiesImpl();
        }
        return maps;
    }

    private boolean validateIncomingMAPs(AddressingProperties maps, Message message) {
        AttributedURIType messageID;
        boolean valid = true;
        if (maps != null && (messageID = maps.getMessageID()) != null && this.messageIDs.put(messageID.getValue(), messageID.getValue()) != null) {
            LOG.log(Level.WARNING, "DUPLICATE_MESSAGE_ID_MSG", messageID.getValue());
            String reason = BUNDLE.getString("DUPLICATE_MESSAGE_ID_MSG");
            String l7dReason = MessageFormat.format(reason, messageID.getValue());
            ContextUtils.storeMAPFaultName("DuplicateMessageID", message);
            ContextUtils.storeMAPFaultReason(l7dReason, message);
            valid = false;
        }
        return valid;
    }

    private void setUsingAddressing(boolean using) {
        this.usingAddressing.set(using);
        this.usingAddressingDetermined.set(true);
    }
}

