/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.jaxb.io;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;

import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.jaxb.JAXBDataReaderFactory;
import org.apache.cxf.jaxb.JAXBEncoderDecoder;
import org.apache.cxf.service.model.MessagePartInfo;

public class EventDataReader implements DataReader<XMLEventReader> {
    final JAXBDataReaderFactory factory;

    public EventDataReader(JAXBDataReaderFactory cb) {
        factory = cb;
    }

    public Object read(XMLEventReader input) {
        return read(null, input);
    }

    public Object read(QName name, XMLEventReader input, Class type) {
        return JAXBEncoderDecoder.unmarshall(factory.getJAXBContext(), factory.getSchema(), input, name,
                                             type, null);
    }

    public Object read(MessagePartInfo part, XMLEventReader input) {
        return JAXBEncoderDecoder.unmarshall(factory.getJAXBContext(), 
                                             factory.getSchema(), 
                                             input,
                                             part,
                                             null);
    }

}
