/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.cxf.systest.common;


import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import junit.framework.TestCase;

import org.apache.cxf.jaxws.spi.ProviderImpl;

public abstract class ClientServerTestBase extends TestCase {

    static {
        System.setProperty("javax.xml.ws.spi.Provider", ProviderImpl.class.getName());
    }

    protected ClientServerTestBase() {
    }

    protected ClientServerTestBase(String name) {
        super(name);
    }
    
    protected HttpURLConnection getHttpConnection(String target) throws Exception {
        URL url = new URL(target);        
        
        URLConnection connection = url.openConnection();            
        
        assertTrue(connection instanceof HttpURLConnection);
        return (HttpURLConnection)connection;        
    }

    protected boolean runClient(Runnable clientImpl, long timeOut, TimeUnit timeUnit)
        throws InterruptedException {
        FutureTask<?> client = new FutureTask<Object>(clientImpl, null);
        ThreadPoolExecutor tpe = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<Runnable>());
        tpe.execute(client);
        tpe.shutdown();
        tpe.awaitTermination(timeOut, timeUnit);
        if (!client.isDone()) {
            return false;
        }
        return true;
    }
}
