/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.eclipse;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.tools.common.VelocityGenerator;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipsePluginMojo
extends AbstractMojo {
    private static final String LIB_PATH = "lib";
    private static final String ECLIPSE_VERSION = "3.2";
    MavenProject project;
    Set dependencies;
    File targetDir;

    private String getTemplateFile(String version) {
        return "/org/apache/cxf/maven_plugin/eclipse/" + version + "/MANIFEST.vm";
    }

    private List<File> listJars() throws Exception {
        ArrayList<File> jars = new ArrayList<File>();
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            for (Artifact artifact : this.dependencies) {
                File oldJar = artifact.getFile();
                jars.add(oldJar);
            }
        }
        return jars;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.generatePluginXML(this.listJars());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private String getVersion() {
        return StringUtils.formatVersionNumber((String)this.project.getVersion());
    }

    private List<String> getExportedPackages(List<File> jars) throws Exception {
        ArrayList<String> packages = new ArrayList<String>();
        for (File jarFile : jars) {
            packages.addAll(ReflectionUtil.getPackagesFromJar((File)jarFile));
        }
        return packages;
    }

    private void generatePluginXML(List<File> jars) throws Exception {
        VelocityGenerator velocity = new VelocityGenerator();
        String templateFile = this.getTemplateFile(ECLIPSE_VERSION);
        velocity.setAttributes("ECLIPSE_VERSION", (Object)ECLIPSE_VERSION);
        velocity.setAttributes("PLUGIN_VERSION", (Object)this.getVersion());
        velocity.setAttributes("GROUP_ID", (Object)this.project.getGroupId());
        velocity.setAttributes("libPath", (Object)LIB_PATH);
        velocity.setAttributes("jars", jars);
        velocity.setAttributes("exportedPackages", this.getExportedPackages(jars));
        File outputFile = new File(this.targetDir, "MANIFEST.MF");
        velocity.doWrite(templateFile, FileWriterUtil.getWriter((File)outputFile));
    }
}

