/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.jbi.se.JarLoader;

public final class ComponentClassLoaderHelper {
    private static final Logger LOG = Logger.getLogger(ComponentClassLoaderHelper.class.getName());
    private static Map<String, byte[]> nonClassesMap = new HashMap<String, byte[]>();

    private ComponentClassLoaderHelper() {
    }

    public static boolean hasResource(String name) {
        try {
            return ComponentClassLoaderHelper.getResourceAsBytes(name) != null;
        }
        catch (IOException ex) {
            LOG.fine("unexpected exception: " + ex);
            return false;
        }
    }

    public static byte[] getResourceAsBytes(String name) throws IOException {
        if (!name.endsWith(".class") && nonClassesMap.containsKey(name)) {
            return nonClassesMap.get(name);
        }
        if (!ComponentClassLoaderHelper.isJarReference(name)) {
            try {
                return JarLoader.getBytesFromInputStream(new URL(name).openStream());
            }
            catch (MalformedURLException mue) {
                throw new IOException(mue.getMessage());
            }
        }
        if (ComponentClassLoaderHelper.isNestedDirectoryReference(name)) {
            throw new IOException("Accessing contents of directories within jars is currently not supported");
        }
        String enclosingJar = name.substring(0, name.lastIndexOf("!/") + 2);
        String resourceName = name.substring(name.lastIndexOf("!/") + 2);
        Map jarMap = JarLoader.getJarContents(enclosingJar);
        if (null != jarMap && jarMap.containsKey(resourceName)) {
            byte[] bytes = (byte[])jarMap.get(resourceName);
            if (!name.endsWith(".class")) {
                nonClassesMap.put(name, bytes);
            }
            return bytes;
        }
        return null;
    }

    private static boolean isJarReference(String name) {
        return name.indexOf("!/") != -1;
    }

    private static boolean isNestedDirectoryReference(String path) {
        String nestedDir = path.substring(path.lastIndexOf("!/") + 2);
        return !"".equals(nestedDir) && nestedDir.endsWith("/");
    }
}

