/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;

public final class JBIMessageHelper {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIMessageHelper.class);
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();

    private JBIMessageHelper() {
    }

    public static InputStream convertMessageToInputStream(Source src) throws IOException, TransformerConfigurationException, TransformerException {
        Transformer transformer = TRANSFORMER_FACTORY.newTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        transformer.transform(src, result);
        LOG.finest(new Message("RECEIVED.MESSAGE", LOG, new Object[0]) + new String(baos.toByteArray()));
        return new ByteArrayInputStream(baos.toByteArray());
    }
}

