/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.messaging.DeliveryChannel;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.se.CXFServiceUnit;
import org.apache.cxf.jbi.se.CXFServiceUnitManager;
import org.apache.cxf.jbi.transport.JBIDestinationOutputStream;
import org.apache.cxf.jbi.transport.JBIMessageHelper;
import org.apache.cxf.jbi.transport.JBITransportFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.AbstractConduit;
import org.apache.cxf.transport.AbstractDestination;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

public class JBIDestination
extends AbstractDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(JBIDestination.class);
    private final DeliveryChannel channel;
    private final CXFServiceUnitManager suManager;
    private ConduitInitiator conduitInitiator;
    private JBIDispatcher dispatcher;
    private volatile boolean running;

    public JBIDestination(ConduitInitiator ci, EndpointInfo info, DeliveryChannel dc, CXFServiceUnitManager sum) {
        super(JBIDestination.getTargetReference((String)info.getAddress()), info);
        this.conduitInitiator = ci;
        this.channel = dc;
        this.suManager = sum;
    }

    protected Logger getLogger() {
        return LOG;
    }

    protected Conduit getInbuiltBackChannel(Message inMessage) {
        return new BackChannelConduit(EndpointReferenceUtils.getAnonymousEndpointReference(), inMessage);
    }

    public void shutdown() {
        this.running = false;
    }

    public void deactivate() {
        this.running = false;
    }

    public void activate() {
        this.getLogger().info(new org.apache.cxf.common.i18n.Message("ACTIVE.JBI.SERVER.TRANSPORT", this.getLogger(), new Object[0]).toString());
        this.dispatcher = new JBIDispatcher();
        new Thread(this.dispatcher).start();
    }

    private void dispatch(MessageExchange exchange) throws IOException {
        QName opName = exchange.getOperation();
        this.getLogger().fine("dispatch method: " + opName);
        NormalizedMessage nm = exchange.getMessage("in");
        try {
            InputStream in = JBIMessageHelper.convertMessageToInputStream(nm.getContent());
            MessageImpl inMessage = new MessageImpl();
            inMessage.put((Object)"cxf.jbi.message.exchange", (Object)exchange);
            inMessage.setContent(InputStream.class, (Object)in);
            inMessage.setDestination((Destination)((JBITransportFactory)this.conduitInitiator).getDestination(exchange.getService().toString() + exchange.getInterfaceName().toString()));
            ((JBITransportFactory)this.conduitInitiator).getDestination(exchange.getService().toString() + exchange.getInterfaceName().toString()).getMessageObserver().onMessage((Message)inMessage);
        }
        catch (Exception ex) {
            this.getLogger().log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.PREPARE.MESSAGE", this.getLogger(), new Object[0]).toString(), ex);
            throw new IOException(ex.getMessage());
        }
    }

    private class JBIDispatcher
    implements Runnable {
        private JBIDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            try {
                JBIDestination.this.running = true;
                JBIDestination.this.getLogger().info(new org.apache.cxf.common.i18n.Message("RECEIVE.THREAD.START", JBIDestination.this.getLogger(), new Object[0]).toString());
                do {
                    MessageExchange exchange = null;
                    DeliveryChannel deliveryChannel = JBIDestination.this.channel;
                    synchronized (deliveryChannel) {
                        exchange = JBIDestination.this.channel.accept();
                    }
                    if (exchange == null) continue;
                    ServiceEndpoint ep = exchange.getEndpoint();
                    CXFServiceUnit csu = JBIDestination.this.suManager.getServiceUnitForEndpoint(ep);
                    ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
                    try {
                        Thread.currentThread().setContextClassLoader(csu.getClassLoader());
                        if (csu != null) {
                            JBIDestination.this.getLogger().info(new org.apache.cxf.common.i18n.Message("DISPATCH.TO.SU", JBIDestination.this.getLogger(), new Object[0]).toString());
                            JBIDestination.this.dispatch(exchange);
                            continue;
                        }
                        JBIDestination.this.getLogger().info(new org.apache.cxf.common.i18n.Message("NO.SU.FOUND", JBIDestination.this.getLogger(), new Object[0]).toString());
                    }
                    finally {
                        Thread.currentThread().setContextClassLoader(oldLoader);
                    }
                } while (JBIDestination.this.running);
            }
            catch (Exception ex) {
                JBIDestination.this.getLogger().log(Level.SEVERE, new org.apache.cxf.common.i18n.Message("ERROR.DISPATCH.THREAD", JBIDestination.this.getLogger(), new Object[0]).toString(), ex);
            }
            JBIDestination.this.getLogger().fine(new org.apache.cxf.common.i18n.Message("JBI.SERVER.TRANSPORT.MESSAGE.PROCESS.THREAD.EXIT", JBIDestination.this.getLogger(), new Object[0]).toString());
        }
    }

    protected class BackChannelConduit
    extends AbstractConduit {
        protected Message inMessage;
        protected JBIDestination jbiDestination;

        BackChannelConduit(EndpointReferenceType ref, Message message) {
            super(ref);
            this.inMessage = message;
        }

        public void setMessageObserver(MessageObserver observer) {
        }

        public void send(Message message) throws IOException {
            message.put((Object)"cxf.jbi.message.exchange", this.inMessage.get((Object)"cxf.jbi.message.exchange"));
            message.setContent(OutputStream.class, (Object)new JBIDestinationOutputStream(this.inMessage, JBIDestination.this.channel));
        }

        protected Logger getLogger() {
            return LOG;
        }
    }
}

