/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ServiceUnitManager;
import javax.jbi.management.DeploymentException;
import javax.jbi.servicedesc.ServiceEndpoint;
import org.apache.cxf.Bus;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.se.CXFServiceUnit;
import org.apache.cxf.jbi.se.ComponentClassLoader;
import org.w3c.dom.Document;

public class CXFServiceUnitManager
implements ServiceUnitManager {
    private static final Logger LOG = LogUtils.getL7dLogger(CXFServiceUnitManager.class);
    private ComponentContext ctx;
    private final Map<String, CXFServiceUnit> serviceUnits = new HashMap<String, CXFServiceUnit>();
    private final Map<ServiceEndpoint, CXFServiceUnit> csuMap = new HashMap<ServiceEndpoint, CXFServiceUnit>();
    private final Bus bus;
    private final ComponentClassLoader componentParentLoader;

    public CXFServiceUnitManager(Bus b, ComponentContext c, ComponentClassLoader loader) {
        this.ctx = c;
        this.bus = b;
        this.componentParentLoader = loader;
    }

    public final void shutDown(String suName) throws DeploymentException {
        LOG.info(new Message("SU.MANAGER.SHUTDOWN", LOG, new Object[0]) + suName);
        if (suName == null) {
            throw new DeploymentException(new Message("SU.NAME.NULL", LOG, new Object[0]).toString());
        }
        if (suName.length() == 0) {
            throw new DeploymentException(new Message("SU.NAME.EMPTY", LOG, new Object[0]).toString());
        }
        if (!this.serviceUnits.containsKey(suName)) {
            throw new DeploymentException(new Message("UNDEPLOYED.SU", LOG, new Object[0]).toString() + suName);
        }
        this.serviceUnits.remove(suName);
    }

    public final String deploy(String suName, String suRootPath) throws DeploymentException {
        LOG.info(new Message("SU.MANAGER.DEPLOY", LOG, new Object[0]) + suName + " path: " + suRootPath);
        if (suName == null) {
            throw new DeploymentException(new Message("SU.NAME.NULL", LOG, new Object[0]).toString());
        }
        if (suName.length() == 0) {
            throw new DeploymentException(new Message("SU.NAME.EMPTY", LOG, new Object[0]).toString());
        }
        if (this.serviceUnits.containsKey(suName)) {
            throw new DeploymentException(new Message("DUPLICATED.SU", LOG, new Object[0]) + suName);
        }
        if (suRootPath == null) {
            throw new DeploymentException(new Message("SU.ROOT.NULL", LOG, new Object[0]).toString());
        }
        if (suRootPath.length() == 0) {
            throw new DeploymentException(new Message("SU.ROOT.EMPTY", LOG, new Object[0]).toString());
        }
        String msg = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><jbi-task xmlns=\"http://java.sun.com/xml/ns/jbi/management-message\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"1.0\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi/management-message ./managementMessage.xsd\"><jbi-task-result><frmwk-task-result><frmwk-task-result-details><task-result-details><task-id>deploy</task-id><task-result>SUCCESS</task-result></task-result-details><locale>en_US</locale></frmwk-task-result-details><is-cause-framework>YES</is-cause-framework></frmwk-task-result><component-task-result><component-name>" + this.ctx.getComponentName() + "</component-name>" + "<component-task-result-details>" + "<task-result-details>" + "<task-id>deploy</task-id>" + "<task-result>SUCCESS</task-result>" + "</task-result-details>" + "</component-task-result-details>" + "</component-task-result>" + "</jbi-task-result>" + "</jbi-task>";
        return msg;
    }

    public final String undeploy(String suName, String suRootPath) throws DeploymentException {
        LOG.info(new Message("SU.MANAGER.UNDEPLOY", LOG, new Object[0]) + suName + " path: " + suRootPath);
        if (suName == null) {
            throw new DeploymentException(new Message("SU.NAME.NULL", LOG, new Object[0]).toString());
        }
        if (suName.length() == 0) {
            throw new DeploymentException(new Message("SU.NAME.EMPTY", LOG, new Object[0]).toString());
        }
        if (suRootPath == null) {
            throw new DeploymentException(new Message("SU.ROOT.NULL", LOG, new Object[0]).toString());
        }
        if (suRootPath.length() == 0) {
            throw new DeploymentException(new Message("SU.ROOT.EMPTY", LOG, new Object[0]).toString());
        }
        String msg = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><jbi-task xmlns=\"http://java.sun.com/xml/ns/jbi/management-message\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" version=\"1.0\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/jbi/management-message ./managementMessage.xsd\"><jbi-task-result><frmwk-task-result><frmwk-task-result-details><task-result-details><task-id>undeploy</task-id><task-result>SUCCESS</task-result></task-result-details><locale>en_US</locale></frmwk-task-result-details></frmwk-task-result><component-task-result><component-name>" + this.ctx.getComponentName() + "</component-name>" + "<component-task-result-details>" + "<task-result-details>" + "<task-id>undeploy</task-id>" + "<task-result>SUCCESS</task-result>" + "</task-result-details>" + "</component-task-result-details>" + "</component-task-result>" + "</jbi-task-result>" + "</jbi-task>";
        this.serviceUnits.remove(suName);
        return msg;
    }

    public final void init(String suName, String suRootPath) throws DeploymentException {
        LOG.info(new Message("SU.MANAGER.INIT", LOG, new Object[0]) + suName + " path: " + suRootPath);
        if (suName == null) {
            throw new DeploymentException(new Message("SU.NAME.NULL", LOG, new Object[0]).toString());
        }
        if (suName.length() == 0) {
            throw new DeploymentException(new Message("SU.NAME.EMPTY", LOG, new Object[0]).toString());
        }
        if (suRootPath == null) {
            throw new DeploymentException(new Message("SU.ROOT.NULL", LOG, new Object[0]).toString());
        }
        if (suRootPath.length() == 0) {
            throw new DeploymentException(new Message("SU.ROOT.EMPTY", LOG, new Object[0]).toString());
        }
        try {
            Thread.currentThread().setContextClassLoader(this.componentParentLoader);
            CXFServiceUnit csu = new CXFServiceUnit(this.bus, suRootPath, this.componentParentLoader);
            csu.prepare(this.ctx);
            this.serviceUnits.put(suName, csu);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DeploymentException((Throwable)ex);
        }
    }

    public final void start(String suName) throws DeploymentException {
        LOG.info(new Message("SU.MANAGER.START", LOG, new Object[0]) + suName);
        if (suName == null) {
            throw new DeploymentException(new Message("SU.NAME.NULL", LOG, new Object[0]).toString());
        }
        if (suName.length() == 0) {
            throw new DeploymentException(new Message("SU.NAME.EMPTY", LOG, new Object[0]).toString());
        }
        if (!this.serviceUnits.containsKey(suName)) {
            throw new DeploymentException(new Message("UNDEPLOYED.SU", LOG, new Object[0]) + suName);
        }
        CXFServiceUnit csu = this.serviceUnits.get(suName);
        assert (csu != null);
        csu.start(this.ctx, this);
    }

    public void putServiceEndpoint(ServiceEndpoint ref, CXFServiceUnit csu) {
        this.csuMap.put(ref, csu);
    }

    public final CXFServiceUnit getServiceUnitForEndpoint(ServiceEndpoint ep) {
        return this.csuMap.get(ep);
    }

    public final void stop(String suName) throws DeploymentException {
        LOG.info(new Message("SU.MANAGER.STOP", LOG, new Object[0]) + suName);
        if (suName == null) {
            throw new DeploymentException(new Message("SU.NAME.NULL", LOG, new Object[0]).toString());
        }
        if (suName.length() == 0) {
            throw new DeploymentException(new Message("SU.NAME.EMPTY", LOG, new Object[0]).toString());
        }
        if (!this.serviceUnits.containsKey(suName)) {
            throw new DeploymentException(new Message("UNDEPLOYED.SU", LOG, new Object[0]) + suName);
        }
        this.serviceUnits.get(suName).stop(this.ctx);
    }

    Document getServiceDescription(ServiceEndpoint serviceEndpoint) {
        Document ret = null;
        if (this.csuMap.keySet().contains(serviceEndpoint)) {
            CXFServiceUnit csu = this.csuMap.get(serviceEndpoint);
            ret = csu.getWsdlAsDocument();
        }
        return ret;
    }
}

