/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jbi.se.state;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jbi.JBIException;
import javax.jbi.component.ComponentContext;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jbi.se.CXFServiceUnitManager;
import org.apache.cxf.jbi.se.ComponentClassLoader;
import org.apache.cxf.jbi.se.state.AbstractServiceEngineStateMachine;
import org.apache.cxf.jbi.se.state.ServiceEngineStateFactory;
import org.apache.cxf.jbi.se.state.ServiceEngineStateMachine;

public class ServiceEngineShutdown
extends AbstractServiceEngineStateMachine {
    private static final Logger LOG = LogUtils.getL7dLogger(ServiceEngineShutdown.class);

    public void changeState(ServiceEngineStateMachine.SEOperation operation, ComponentContext context) throws JBIException {
        LOG.info("in shutdown state");
        if (operation == ServiceEngineStateMachine.SEOperation.init) {
            this.initSE(context);
            ServiceEngineStateFactory.getInstance().setCurrentState(ServiceEngineStateFactory.getInstance().getStopState());
        } else {
            if (operation == ServiceEngineStateMachine.SEOperation.shutdown) {
                throw new JBIException("This JBI component is already shutdown");
            }
            if (operation == ServiceEngineStateMachine.SEOperation.stop) {
                throw new JBIException("This operation is unsupported, cannot stop a shutdown JBI component");
            }
            if (operation == ServiceEngineStateMachine.SEOperation.start) {
                throw new JBIException("Cannot start a shutdown JBI component directly, need init first");
            }
        }
    }

    private void initSE(ComponentContext context) throws JBIException {
        try {
            System.setProperty("javax.xml.ws.spi.Provider", "org.apache.cxf.jaxws.spi.ProviderImpl");
            ctx = context;
            if (ctx == null) {
                return;
            }
            String installRoot = ctx.getInstallRoot();
            File metaInfDir = new File(installRoot, "META-INF");
            File cxfConfig = new File(metaInfDir, "cxf.xml");
            if (cxfConfig.exists()) {
                System.setProperty("cxf.config.file", cxfConfig.toURI().toURL().toString());
                LOG.info(new Message("SE.SET.CONFIGURATION", LOG, new Object[0]) + "cxf.config.file");
            } else {
                LOG.severe(new Message("SE.NOT.FOUND.CONFIGURATION", LOG, new Object[0]).toString() + metaInfDir);
            }
            ComponentClassLoader loader = this.createClassLoader();
            Thread.currentThread().setContextClassLoader(loader);
            this.initializeBus();
            suManager = new CXFServiceUnitManager(bus, ctx, loader);
            this.registerJBITransport(bus, suManager);
            LOG.info(new Message("SE.INSTALL.ROOT", LOG, new Object[0]) + installRoot);
            LOG.info(new Message("SE.INIT.COMPLETE", LOG, new Object[0]).toString());
        }
        catch (Throwable e) {
            throw new JBIException(e);
        }
    }

    private void initializeBus() throws JBIException {
        try {
            LOG.info(new Message("SE.INIT.BUS", LOG, new Object[0]).toString());
            if (null == bus) {
                bus = BusFactory.newInstance().createBus();
            }
            LOG.info(new Message("SE.INIT.BUS.COMPLETE", LOG, new Object[0]).toString());
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, new Message("SE.FAILED.INIT.BUS", LOG, new Object[0]).toString(), ex);
            throw new JBIException((Throwable)ex);
        }
    }

    private ComponentClassLoader createClassLoader() throws JBIException, IOException, ClassNotFoundException {
        try {
            URL[] urls;
            File root = new File(ctx.getInstallRoot());
            File[] jars = root.listFiles(new FilenameFilter(){

                public boolean accept(File f, String name) {
                    return name.endsWith(".jar");
                }
            });
            if (jars.length == 0) {
                urls = new URL[]{};
            } else {
                urls = new URL[jars.length];
                int i = 0;
                for (File jar : jars) {
                    urls[i] = jar.toURI().toURL();
                    ++i;
                }
            }
            return new ComponentClassLoader(urls, this.getClass().getClassLoader());
        }
        catch (MalformedURLException ex) {
            throw new JBIException(new Message("SE.FAILED.CLASSLOADER", LOG, new Object[0]).toString(), (Throwable)ex);
        }
    }
}

