/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jca.core.resourceadapter;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jca.core.logging.LoggerHelper;
import org.apache.cxf.jca.core.resourceadapter.ResourceAdapterInternalException;

public class ResourceBean
implements Serializable {
    public static final String DEFAULT_VALUE_STRING = "DEFAULT";
    public static final String LOG_LEVEL = "log.level";
    public static final String CONFIG_DOMAIN = "cxf";
    public static final String CONFIG_SCOPE = "j2ee";
    public static final String DEFAULT_MONITOR_POLL_INTERVAL = "120";
    public static final String EJB_SERVICE_PROPERTIES_URL = "ejb.service.properties.url";
    public static final String MONITOR_EJB_SERVICE_PROPERTIES = "monitor.ejb.service.properties";
    public static final String MONITOR_POLL_INTERVAL = "monitor.poll.interval";
    public static final String EJB_SERVANT_BASE_URL = "ejb.servant.base.url";
    private static final Logger LOG;
    private Properties pluginProps;

    public ResourceBean() {
        this.pluginProps = new Properties();
    }

    public ResourceBean(Properties props) {
        this.pluginProps = props;
    }

    public void setDisableConsoleLogging(boolean disable) {
        if (disable) {
            LoggerHelper.disableConsoleLogging();
        }
    }

    public Properties getPluginProps() {
        return this.pluginProps;
    }

    public void setProperty(String propName, String propValue) {
        if (!DEFAULT_VALUE_STRING.equals(propValue)) {
            LOG.log(Level.FINE, "SETTING_PROPERTY", new Object[]{propName, propValue});
            this.getPluginProps().setProperty(propName, propValue);
        }
        if (LOG_LEVEL.equals(propName)) {
            LoggerHelper.setLogLevel(propValue);
        }
    }

    protected URL getPropsURL(String propsUrl) throws ResourceException {
        URL ret = null;
        if (propsUrl != null) {
            ret = this.createURL(propsUrl, "Unable to construct URL from URL string, value=" + propsUrl);
        }
        return ret;
    }

    protected URL createURL(String spec, String msg) throws ResourceAdapterInternalException {
        try {
            return new URL(spec);
        }
        catch (MalformedURLException mue) {
            throw new ResourceAdapterInternalException(msg, mue);
        }
    }

    public void validateURLString(String spec, String msg) throws ResourceAdapterInternalException {
        URL url = null;
        try {
            url = this.createURL(spec, msg);
            url.openStream();
            LOG.fine("Validated url=" + url);
        }
        catch (IOException ioe) {
            throw new ResourceAdapterInternalException(msg, ioe);
        }
    }

    static {
        LoggerHelper.init();
        LOG = LogUtils.getL7dLogger(ResourceBean.class);
    }
}

