/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.coloc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.coloc.ColocOutFaultObserver;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ColocUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(ColocUtil.class);

    private ColocUtil() {
    }

    public static void setPhases(SortedSet<Phase> list, String start, String end) {
        Phase startPhase = new Phase(start, 1);
        Phase endPhase = new Phase(end, 2);
        Iterator iter = list.iterator();
        boolean remove = true;
        while (iter.hasNext()) {
            Phase p = (Phase)iter.next();
            if (remove && p.getName().equals(startPhase.getName())) {
                remove = false;
                continue;
            }
            if (p.getName().equals(endPhase.getName())) {
                remove = true;
                continue;
            }
            if (!remove) continue;
            iter.remove();
        }
    }

    public static InterceptorChain getOutInterceptorChain(Exchange ex, SortedSet<Phase> phases) {
        Bus bus = (Bus)ex.get(Bus.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(phases);
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        List il = ep.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain.add((Collection)il);
        il = ep.getService().getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by service: " + il);
        }
        chain.add((Collection)il);
        il = bus.getOutInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add((Collection)il);
        if (ep.getService().getDataBinding() instanceof InterceptorProvider) {
            il = ((InterceptorProvider)ep.getService().getDataBinding()).getOutInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by databinding: " + il);
            }
            chain.add((Collection)il);
        }
        ColocUtil.modifyChain(chain, ex, false);
        return chain;
    }

    public static InterceptorChain getInInterceptorChain(Exchange ex, SortedSet<Phase> phases) {
        Bus bus = (Bus)ex.get(Bus.class);
        PhaseInterceptorChain chain = new PhaseInterceptorChain(phases);
        Endpoint ep = (Endpoint)ex.get(Endpoint.class);
        List il = ep.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by endpoint: " + il);
        }
        chain.add((Collection)il);
        il = ep.getService().getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by service: " + il);
        }
        chain.add((Collection)il);
        il = bus.getInInterceptors();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Interceptors contributed by bus: " + il);
        }
        chain.add((Collection)il);
        if (ep.getService().getDataBinding() instanceof InterceptorProvider) {
            il = ((InterceptorProvider)ep.getService().getDataBinding()).getInInterceptors();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Interceptors contributed by databinding: " + il);
            }
            chain.add((Collection)il);
        }
        chain.setFaultObserver((MessageObserver)new ColocOutFaultObserver(bus));
        ColocUtil.modifyChain(chain, ex, true);
        return chain;
    }

    private static void modifyChain(PhaseInterceptorChain chain, Exchange ex, boolean in) {
        ColocUtil.modifyChain(chain, ex.getInMessage(), in);
        ColocUtil.modifyChain(chain, ex.getOutMessage(), in);
    }

    private static void modifyChain(PhaseInterceptorChain chain, Message m, boolean in) {
        String key;
        Collection is;
        if (m == null) {
            return;
        }
        Collection providers = CastUtils.cast((Collection)((Collection)m.get((Object)Message.INTERCEPTOR_PROVIDERS)));
        if (providers != null) {
            for (InterceptorProvider p : providers) {
                if (in) {
                    chain.add((Collection)p.getInInterceptors());
                    continue;
                }
                chain.add((Collection)p.getOutInterceptors());
            }
        }
        if ((is = CastUtils.cast((Collection)((Collection)m.get((Object)(key = in ? Message.IN_INTERCEPTORS : Message.OUT_INTERCEPTORS))))) != null) {
            chain.add(is);
        }
    }

    public static boolean isSameOperationInfo(OperationInfo oi1, OperationInfo oi2) {
        return oi1.getName().equals(oi2.getName()) && ColocUtil.isSameMessageInfo(oi1.getInput(), oi2.getInput()) && ColocUtil.isSameMessageInfo(oi1.getOutput(), oi2.getOutput()) && ColocUtil.isSameFaultInfo(oi1.getFaults(), oi2.getFaults());
    }

    public static boolean isCompatibleOperationInfo(OperationInfo oi1, OperationInfo oi2) {
        return ColocUtil.isSameOperationInfo(oi1, oi2) || ColocUtil.isAssignableOperationInfo(oi1, Source.class) || ColocUtil.isAssignableOperationInfo(oi2, Source.class);
    }

    public static boolean isAssignableOperationInfo(OperationInfo oi, Class<?> cls) {
        MessageInfo mi = oi.getInput();
        List mpis = mi.getMessageParts();
        return mpis.size() == 1 && cls.isAssignableFrom(((MessagePartInfo)mpis.get(0)).getTypeClass());
    }

    public static boolean isSameMessageInfo(MessageInfo mi1, MessageInfo mi2) {
        if (mi1 == null && mi2 != null || mi1 != null && mi2 == null) {
            return false;
        }
        if (mi1 != null && mi2 != null) {
            List mpil1 = mi1.getMessageParts();
            List mpil2 = mi2.getMessageParts();
            if (mpil1.size() != mpil2.size()) {
                return false;
            }
            int idx = 0;
            for (MessagePartInfo mpi1 : mpil1) {
                MessagePartInfo mpi2 = (MessagePartInfo)mpil2.get(idx);
                if (!mpi1.getTypeClass().equals(mpi2.getTypeClass())) {
                    return false;
                }
                ++idx;
            }
        }
        return true;
    }

    public static boolean isSameFaultInfo(Collection<FaultInfo> fil1, Collection<FaultInfo> fil2) {
        if (fil1 == null && fil2 != null || fil1 != null && fil2 == null) {
            return false;
        }
        if (fil1 != null && fil2 != null) {
            if (fil1.size() != fil2.size()) {
                return false;
            }
            for (FaultInfo fi1 : fil1) {
                Iterator<FaultInfo> iter = fil2.iterator();
                Class fiClass1 = (Class)fi1.getProperty(Class.class.getName(), Class.class);
                boolean match = false;
                while (iter.hasNext()) {
                    FaultInfo fi2 = iter.next();
                    Class fiClass2 = (Class)fi2.getProperty(Class.class.getName(), Class.class);
                    if (!fiClass1.equals(fiClass2)) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    public static void convertSourceToObject(Message message) {
        List content = CastUtils.cast((List)((List)message.getContent(List.class)));
        if (content == null || content.size() < 1) {
            return;
        }
        Source source = (Source)content.get(0);
        DataReader reader = message.getExchange().getService().getDataBinding().createReader(XMLStreamReader.class);
        MessagePartInfo mpi = ColocUtil.getMessageInfo(message).getMessagePart(0);
        Object wrappedObject = reader.read(mpi, (Object)StaxUtils.createXMLStreamReader((Source)source));
        MessageContentsList parameters = new MessageContentsList();
        parameters.put(mpi, wrappedObject);
        message.setContent(List.class, (Object)parameters);
    }

    public static void convertObjectToSource(Message message) {
        List content = CastUtils.cast((List)((List)message.getContent(List.class)));
        if (content == null || content.size() < 1) {
            return;
        }
        Object object = content.get(0);
        DataWriter writer = message.getExchange().getService().getDataBinding().createWriter(OutputStream.class);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        writer.write(object, (Object)bos);
        content.set(0, new StreamSource(new ByteArrayInputStream(bos.toByteArray())));
    }

    private static MessageInfo getMessageInfo(Message message) {
        OperationInfo oi = (OperationInfo)message.getExchange().get(OperationInfo.class);
        if (MessageUtils.isOutbound((Message)message)) {
            return oi.getOutput();
        }
        return oi.getInput();
    }
}

