/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.service.factory.AbstractBindingInfoFactoryBean;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;

public class SoapBindingInfoFactoryBean
extends AbstractBindingInfoFactoryBean {
    private SoapVersion soapVersion = Soap11.getInstance();
    private String style = "document";
    private String use;
    private String transportURI = "http://schemas.xmlsoap.org/soap/http";

    public BindingInfo create() {
        ServiceInfo si = this.getServiceInfo();
        SoapBindingInfo info = new SoapBindingInfo(si, "http://schemas.xmlsoap.org/wsdl/soap/", this.soapVersion);
        info.setName(this.getBindingName());
        info.setStyle(this.getStyle());
        info.setTransportURI(this.getTransportURI());
        for (OperationInfo op : si.getInterface().getOperations()) {
            SoapOperationInfo sop = new SoapOperationInfo();
            sop.setAction(this.getSoapAction(op));
            sop.setStyle(this.getStyle(op));
            BindingOperationInfo bop = info.buildOperation(op.getName(), op.getInputName(), op.getOutputName());
            bop.addExtensor((Object)sop);
            info.addOperation(bop);
        }
        return info;
    }

    private String getSoapAction(OperationInfo op) {
        return "";
    }

    public String getTransportURI() {
        return this.transportURI;
    }

    public void setTransportURI(String transportURI) {
        this.transportURI = transportURI;
    }

    protected String getStyle() {
        return this.style;
    }

    protected String getStyle(OperationInfo op) {
        return this.getStyle();
    }

    protected QName getBindingName() {
        ServiceInfo si = this.getServiceInfo();
        return new QName(si.getName().getNamespaceURI(), si.getName().getLocalPart() + "SoapBinding");
    }

    public SoapVersion getSoapVersion() {
        return this.soapVersion;
    }

    public void setSoapVersion(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public void setStyle(String style) {
        this.style = style;
    }
}

