/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.interceptor.Fault;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapFault
extends Fault {
    public static final QName ATTACHMENT_IO = new QName("http://www.w3.org/2003/05/soap-envelope", "AttachmentIOError");
    private QName faultCode;
    private QName subCode;
    private String role;
    private String node;
    private Map<String, String> namespaces = new HashMap<String, String>();

    public SoapFault(Message message, Throwable throwable, QName faultCode) {
        super(message, throwable);
        this.faultCode = faultCode;
    }

    public SoapFault(Message message, QName faultCode) {
        super(message);
        this.faultCode = faultCode;
    }

    public SoapFault(String message, QName faultCode) {
        super(new Message(message, (ResourceBundle)null, new Object[0]));
        this.faultCode = faultCode;
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public String getCodeString(String prefix, String defaultPrefix) {
        return this.getFaultCodeString(prefix, defaultPrefix, this.faultCode);
    }

    public String getSubCodeString(String prefix, String defaultPrefix) {
        return this.getFaultCodeString(prefix, defaultPrefix, this.subCode);
    }

    private String getFaultCodeString(String prefix, String defaultPrefix, QName fCode) {
        String codePrefix = null;
        if (StringUtils.isEmpty((String)prefix)) {
            codePrefix = fCode.getPrefix();
            if (StringUtils.isEmpty((String)codePrefix)) {
                codePrefix = defaultPrefix;
            }
        } else {
            codePrefix = prefix;
        }
        return prefix + ":" + fCode.getLocalPart();
    }

    public void setFaultCode(QName faultCode) {
        this.faultCode = faultCode;
    }

    public String getReason() {
        return this.getMessage();
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String actor) {
        this.role = actor;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String n) {
        this.node = n;
    }

    public QName getSubCode() {
        return this.subCode;
    }

    public void setSubCode(QName subCode) {
        this.subCode = subCode;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = namespaces;
    }

    public static SoapFault createFault(Fault f, SoapVersion v) {
        if (f instanceof SoapFault) {
            return (SoapFault)f;
        }
        SoapFault soapFault = new SoapFault(new Message(f.getMessage(), (ResourceBundle)null, new Object[0]), f.getCause(), v.getReceiver());
        soapFault.setDetail(f.getDetail());
        return soapFault;
    }
}

