/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.HeaderUtil;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MustUnderstandInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(MustUnderstandInterceptor.class);
    private static final ResourceBundle BUNDLE = LOG.getResourceBundle();

    public MustUnderstandInterceptor() {
        this.setPhase("pre-protocol");
    }

    public void handleMessage(SoapMessage soapMessage) {
        SoapVersion soapVersion = soapMessage.getVersion();
        if (this.isRequestor((Message)soapMessage)) {
            return;
        }
        HashSet<Element> mustUnderstandHeaders = new HashSet<Element>();
        HashSet<URI> serviceRoles = new HashSet<URI>();
        HashSet<QName> notUnderstandQNames = new HashSet<QName>();
        HashSet<QName> mustUnderstandQNames = new HashSet<QName>();
        this.buildMustUnderstandHeaders(mustUnderstandHeaders, soapMessage, serviceRoles);
        this.initServiceSideInfo(mustUnderstandQNames, soapMessage, serviceRoles);
        if (!this.checkUnderstand(mustUnderstandHeaders, mustUnderstandQNames, notUnderstandQNames)) {
            StringBuffer sb = new StringBuffer(300);
            int pos = 0;
            for (QName qname : notUnderstandQNames) {
                pos = pos + qname.toString().length() + 2;
                sb.append(qname.toString() + ", ");
            }
            sb.delete(pos - 2, pos);
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("MUST_UNDERSTAND", BUNDLE, new Object[]{sb.toString()}), soapVersion.getMustUnderstand());
        }
    }

    private void initServiceSideInfo(Set<QName> mustUnderstandQNames, SoapMessage soapMessage, Set<URI> serviceRoles) {
        Set<QName> paramHeaders = HeaderUtil.getHeaderQNameInOperationParam(soapMessage);
        if (paramHeaders != null) {
            mustUnderstandQNames.addAll(paramHeaders);
        }
        for (Interceptor interceptorInstance : soapMessage.getInterceptorChain()) {
            if (!(interceptorInstance instanceof SoapInterceptor)) continue;
            SoapInterceptor si = (SoapInterceptor)interceptorInstance;
            serviceRoles.addAll(si.getRoles());
            mustUnderstandQNames.addAll(si.getUnderstoodHeaders());
        }
    }

    private void buildMustUnderstandHeaders(Set<Element> mustUnderstandHeaders, SoapMessage soapMessage, Set<URI> serviceRoles) {
        int i;
        Element headers = null;
        if (soapMessage.hasHeaders(Element.class)) {
            headers = soapMessage.getHeaders(Element.class);
        }
        ArrayList<Element> headerChilds = new ArrayList<Element>();
        if (headers != null) {
            for (i = 0; i < headers.getChildNodes().getLength(); ++i) {
                if (!(headers.getChildNodes().item(i) instanceof Element)) continue;
                headerChilds.add((Element)headers.getChildNodes().item(i));
            }
        }
        for (i = 0; i < headerChilds.size(); ++i) {
            Element header = (Element)headerChilds.get(i);
            String mustUnderstand = header.getAttributeNS(soapMessage.getVersion().getNamespace(), soapMessage.getVersion().getAttrNameMustUnderstand());
            if (!Boolean.valueOf(mustUnderstand).booleanValue() && !"1".equals(mustUnderstand.trim())) continue;
            String role = header.getAttributeNS(soapMessage.getVersion().getNamespace(), soapMessage.getVersion().getAttrNameRole());
            if (role != null) {
                if ((role = role.trim()).equals(soapMessage.getVersion().getNextRole()) || role.equals(soapMessage.getVersion().getUltimateReceiverRole())) {
                    mustUnderstandHeaders.add(header);
                    continue;
                }
                for (URI roleFromBinding : serviceRoles) {
                    if (!role.equals(roleFromBinding)) continue;
                    mustUnderstandHeaders.add(header);
                }
                continue;
            }
            mustUnderstandHeaders.add(header);
        }
    }

    private boolean checkUnderstand(Set<Element> mustUnderstandHeaders, Set<QName> mustUnderstandQNames, Set<QName> notUnderstandQNames) {
        for (Element header : mustUnderstandHeaders) {
            QName qname = new QName(header.getNamespaceURI(), header.getLocalName());
            if (mustUnderstandQNames.contains(qname)) continue;
            notUnderstandQNames.add(qname);
        }
        return notUnderstandQNames.size() <= 0;
    }
}

