/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceModelUtil;
import org.apache.cxf.staxutils.StaxUtils;

public class RPCOutInterceptor
extends AbstractOutDatabindingInterceptor {
    public RPCOutInterceptor() {
        this.setPhase("marshal");
    }

    public void handleMessage(Message message) {
        try {
            NSStack nsStack = new NSStack();
            nsStack.push();
            BindingOperationInfo operation = (BindingOperationInfo)message.getExchange().get((Object)BindingOperationInfo.class.getName());
            assert (operation.getName() != null);
            XMLStreamWriter xmlWriter = this.getXMLStreamWriter(message);
            DataWriter dataWriter = this.getMessageDataWriter(message);
            this.addOperationNode(nsStack, message, xmlWriter);
            int countParts = 0;
            List parts = null;
            parts = !this.isRequestor(message) ? operation.getOutput().getMessageInfo().getMessageParts() : operation.getInput().getMessageInfo().getMessageParts();
            countParts = parts.size();
            if (countParts > 0) {
                List objs = (List)message.getContent(List.class);
                if (objs.size() < parts.size()) {
                    throw new SoapFault("The number of arguments is not equal!", ((SoapMessage)message).getVersion().getSender());
                }
                for (int idx = 0; idx < countParts; ++idx) {
                    Object arg = objs.get(idx);
                    MessagePartInfo part = (MessagePartInfo)parts.get(idx);
                    dataWriter.write(arg, part, (Object)message);
                }
            }
            xmlWriter.writeEndElement();
            message.getInterceptorChain().finishSubChain();
        }
        catch (XMLStreamException e) {
            throw new Fault((Throwable)e);
        }
    }

    protected String addOperationNode(NSStack nsStack, Message message, XMLStreamWriter xmlWriter) throws XMLStreamException {
        String responseSuffix = !this.isRequestor(message) ? "Response" : "";
        String namespaceURI = ServiceModelUtil.getTargetNamespace((Exchange)message.getExchange());
        nsStack.add(namespaceURI);
        String prefix = nsStack.getPrefix(namespaceURI);
        String operationName = this.getOperationName(message) + responseSuffix;
        StaxUtils.writeStartElement((XMLStreamWriter)xmlWriter, (String)prefix, (String)operationName, (String)namespaceURI);
        return namespaceURI;
    }

    protected XMLStreamWriter getXMLStreamWriter(Message message) {
        return (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
    }

    private String getOperationName(Message message) {
        BindingOperationInfo boi = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
        return boi.getOperationInfo().getName().getLocalPart();
    }
}

