/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.io.InputStream;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.PartialXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReadHeadersInterceptor
extends AbstractSoapInterceptor {
    private static final Logger LOG = Logger.getLogger(ReadHeadersInterceptor.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ReadHeadersInterceptor.class);

    public ReadHeadersInterceptor() {
        this.setPhase("read");
    }

    public void handleMessage(SoapMessage message) {
        if (this.isGET((Message)message)) {
            LOG.info("ReadHeadersInterceptor skipped in HTTP GET method");
            return;
        }
        XMLStreamReader xmlReader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        if (xmlReader == null) {
            InputStream in = (InputStream)message.getContent(InputStream.class);
            if (in == null) {
                throw new RuntimeException("Can't found input stream in message");
            }
            xmlReader = StaxUtils.createXMLStreamReader((InputStream)in);
        }
        try {
            while (xmlReader.isWhiteSpace()) {
                xmlReader.next();
            }
            if (xmlReader.nextTag() == 1) {
                String ns = xmlReader.getNamespaceURI();
                SoapVersion soapVersion = SoapVersionFactory.getInstance().getSoapVersion(ns);
                message.setVersion(soapVersion);
                QName qn = xmlReader.getName();
                while (!qn.equals(message.getVersion().getBody()) && !qn.equals(message.getVersion().getHeader())) {
                    while (xmlReader.nextTag() != 1) {
                    }
                    qn = xmlReader.getName();
                }
                if (qn.equals(message.getVersion().getHeader())) {
                    PartialXMLStreamReader filteredReader = new PartialXMLStreamReader(xmlReader, message.getVersion().getBody());
                    Document doc = StaxUtils.read((XMLStreamReader)filteredReader);
                    Element element = (Element)doc.getChildNodes().item(0);
                    message.setHeaders(Element.class, element);
                    message.put(Element.class, element);
                }
                xmlReader.nextTag();
                if (xmlReader.getName().equals(message.getVersion().getBody())) {
                    xmlReader.nextTag();
                }
                if (message.getVersion().getFault().equals(xmlReader.getName())) {
                    Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
                    if (!this.isDecoupled(message)) {
                        message.getInterceptorChain().abort();
                        if (ep.getInFaultObserver() != null) {
                            ep.getInFaultObserver().onMessage((Message)message);
                        }
                    } else {
                        message.getExchange().put((Object)"deferred.fault.observer.notification", (Object)Boolean.TRUE);
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("XML_STREAM_EXC", BUNDLE, new Object[0]), e, message.getVersion().getSender());
        }
    }

    private boolean isDecoupled(SoapMessage message) {
        Boolean decoupled = (Boolean)message.get("decoupled.channel.message");
        return decoupled != null && decoupled != false;
    }
}

