/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.ClientFaultConverter;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.staxutils.FragmentStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;

public class Soap11FaultInInterceptor
extends AbstractSoapInterceptor {
    public Soap11FaultInInterceptor() {
        this.setPhase("unmarshal");
        this.addBefore(ClientFaultConverter.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        String exMessage = null;
        QName faultCode = null;
        String role = null;
        Element detail = null;
        XMLStreamReader reader = (XMLStreamReader)message.getContent(XMLStreamReader.class);
        try {
            while (reader.nextTag() == 1) {
                if (reader.getLocalName().equals("faultcode")) {
                    faultCode = StaxUtils.readQName((XMLStreamReader)reader);
                    continue;
                }
                if (reader.getLocalName().equals("faultstring")) {
                    exMessage = reader.getElementText();
                    continue;
                }
                if (reader.getLocalName().equals("faultactor")) {
                    role = reader.getElementText();
                    continue;
                }
                if (!reader.getLocalName().equals("detail")) continue;
                detail = StaxUtils.read((XMLStreamReader)new FragmentStreamReader(reader)).getDocumentElement();
            }
        }
        catch (XMLStreamException e) {
            throw new SoapFault("Could not parse message.", message.getVersion().getSender());
        }
        SoapFault fault = new SoapFault(exMessage, faultCode);
        fault.setDetail(detail);
        fault.setRole(role);
        message.setContent(Exception.class, (Object)fault);
    }
}

