/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.HashMap;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;

public class SoapPreProtocolOutInterceptor
extends AbstractSoapInterceptor {
    public SoapPreProtocolOutInterceptor() {
        this.setPhase("pre-stream");
        this.getBefore().add(AttachmentOutInterceptor.class.getName());
    }

    public void handleMessage(SoapMessage message) throws Fault {
        this.ensureVersion(message);
        this.ensureMimeHeaders(message);
    }

    private void ensureVersion(SoapMessage message) {
        SoapVersion soapVersion = message.getVersion();
        if (soapVersion == null && message.getExchange().getInMessage() instanceof SoapMessage) {
            soapVersion = ((SoapMessage)message.getExchange().getInMessage()).getVersion();
            message.setVersion(soapVersion);
        }
        if (soapVersion == null) {
            soapVersion = Soap11.getInstance();
            message.setVersion(soapVersion);
        }
    }

    private void ensureMimeHeaders(SoapMessage message) {
        if (message.get("org.apache.cxf.mime.headers") == null) {
            message.put("org.apache.cxf.mime.headers", new HashMap());
        }
    }
}

