/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.tcp.frames;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.cxf.binding.soap.tcp.DataCodingUtils;
import org.apache.cxf.binding.soap.tcp.frames.SoapTcpFrameContentDescription;

public class SoapTcpFrameHeader {
    public static final int SINGLE_FRAME_MESSAGE = 0;
    public static final int MESSAGE_START_CHUNK = 1;
    public static final int MESSAGE_CHUNK = 2;
    public static final int MESSAGE_END_CHUNK = 3;
    public static final int ERROR_MESSAGE = 4;
    public static final int NULL_MESSAGE = 5;
    private int channelId;
    private int frameType;
    private SoapTcpFrameContentDescription contentDescription;

    public SoapTcpFrameHeader(int frameType, SoapTcpFrameContentDescription contentDescription) {
        this.frameType = frameType;
        this.contentDescription = contentDescription;
    }

    public SoapTcpFrameHeader() {
        this.frameType = 5;
        this.contentDescription = null;
    }

    public int getChannelId() {
        return this.channelId;
    }

    public void setChannelId(int channelId) {
        this.channelId = channelId;
    }

    public int getFrameType() {
        return this.frameType;
    }

    public void setFrameType(int frameType) {
        this.frameType = frameType;
    }

    public SoapTcpFrameContentDescription getContentDescription() {
        return this.contentDescription;
    }

    public void setContentDescription(SoapTcpFrameContentDescription contentDescription) {
        this.contentDescription = contentDescription;
    }

    public void write(OutputStream output) throws IOException {
        DataCodingUtils.writeInts4(output, this.channelId, this.frameType);
        if ((this.frameType == 0 || this.frameType == 1) && this.contentDescription != null) {
            this.contentDescription.write(output);
        }
    }
}

