/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.mtom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.mtom.AttachmentUtil;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.message.Attachment;

public abstract class AbstractXOPType
extends Type {
    public static final String XOP_NS = "http://www.w3.org/2004/08/xop/include";
    public static final String XML_MIME_NS = "http://www.w3.org/2004/11/xmlmime";
    public static final QName XOP_INCLUDE = new QName("http://www.w3.org/2004/08/xop/include", "Include");
    public static final QName XOP_HREF = new QName("href");
    public static final QName XML_MIME_TYPE = new QName("http://www.w3.org/2004/11/xmlmime", "mimeType");

    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        Object o = null;
        while (reader.hasMoreElementReaders()) {
            MessageReader child = reader.getNextElementReader();
            if (child.getName().equals(XOP_INCLUDE)) {
                MessageReader mimeReader = child.getAttributeReader(XOP_HREF);
                String type = mimeReader.getValue();
                o = this.readInclude(type, child, context);
            }
            child.readToEnd();
        }
        return o;
    }

    public Object readInclude(String type, MessageReader reader, Context context) throws DatabindingException {
        String href = reader.getAttributeReader(XOP_HREF).getValue();
        Attachment att = AttachmentUtil.getAttachment(href, context.getAttachments());
        if (att == null) {
            throw new DatabindingException("Could not find the attachment " + href);
        }
        try {
            return this.readAttachment(att, context);
        }
        catch (IOException e) {
            throw new DatabindingException("Could not read attachment", e);
        }
    }

    protected abstract Object readAttachment(Attachment var1, Context var2) throws IOException;

    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        Collection<Attachment> attachments = context.getAttachments();
        if (attachments == null) {
            attachments = new ArrayList<Attachment>();
            context.setAttachments(attachments);
        }
        String id = AttachmentUtil.createContentID(this.getSchemaType().getNamespaceURI());
        Attachment att = this.createAttachment(object, id);
        attachments.add(att);
        String contentType = this.getContentType(object, context);
        if (contentType != null) {
            MessageWriter mt = writer.getAttributeWriter(XML_MIME_TYPE);
            mt.writeValue(contentType);
        }
        MessageWriter include = writer.getElementWriter(XOP_INCLUDE);
        MessageWriter href = include.getAttributeWriter(XOP_HREF);
        href.writeValue("cid:" + id);
        include.close();
    }

    protected abstract Attachment createAttachment(Object var1, String var2);

    protected abstract String getContentType(Object var1, Context var2);
}

