/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.BeanTypeInfo;
import org.apache.cxf.aegis.type.basic.InterfaceInvocationHandler;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanType
extends Type {
    private BeanTypeInfo info;
    private boolean isInterface;
    private boolean isException;

    public BeanType() {
    }

    public BeanType(BeanTypeInfo info) {
        this.info = info;
        this.typeClass = info.getTypeClass();
        this.initTypeClass();
    }

    private void initTypeClass() {
        this.isInterface = this.typeClass.isInterface();
        this.isException = Exception.class.isAssignableFrom(this.typeClass);
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        BeanTypeInfo inf = this.getTypeInfo();
        try {
            QName name;
            MessageReader childReader;
            Class clazz = this.getTypeClass();
            Object object = null;
            InterfaceInvocationHandler delegate = null;
            boolean isProxy = false;
            if (this.isInterface) {
                String impl = (String)context.get(clazz.getName() + ".implementation");
                if (impl == null) {
                    delegate = new InterfaceInvocationHandler();
                    object = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)delegate);
                    isProxy = true;
                } else {
                    try {
                        clazz = ClassLoaderUtils.loadClass((String)impl, this.getClass());
                        object = clazz.newInstance();
                    }
                    catch (ClassNotFoundException e) {
                        throw new DatabindingException("Could not find implementation class " + impl + " for class " + clazz.getName());
                    }
                }
            } else {
                object = this.isException ? this.createFromFault(context) : (Object)clazz.newInstance();
            }
            while (reader.hasMoreAttributeReaders()) {
                childReader = reader.getNextAttributeReader();
                name = childReader.getName();
                Type type = inf.getType(name);
                if (type == null) continue;
                Object writeObj = type.readObject(childReader, context);
                if (isProxy) {
                    delegate.writeProperty(name.getLocalPart(), writeObj);
                    continue;
                }
                this.writeProperty(name, object, writeObj, clazz, inf);
            }
            while (reader.hasMoreElementReaders()) {
                Type type;
                childReader = reader.getNextElementReader();
                name = childReader.getName();
                BeanType parent = this.getBeanTypeWithProperty(name);
                Type defaultType = null;
                if (parent != null) {
                    this.info = parent.getTypeInfo();
                    defaultType = this.info.getType(name);
                }
                if ((type = TypeUtil.getReadType(childReader.getXMLStreamReader(), context, defaultType)) == null) {
                    parent = this.getBeanTypeWithProperty(name);
                    if (parent != null) {
                        inf = parent.getTypeInfo();
                        type = inf.getType(name);
                    } else {
                        type = null;
                    }
                }
                if (type != null) {
                    if (!childReader.isXsiNil()) {
                        Object writeObj = type.readObject(childReader, context);
                        if (isProxy) {
                            delegate.writeProperty(name.getLocalPart(), writeObj);
                            continue;
                        }
                        this.writeProperty(name, object, writeObj, clazz, inf);
                        continue;
                    }
                    if (!inf.isNillable(name)) {
                        throw new DatabindingException(name.getLocalPart() + " is nil, but not nillable.");
                    }
                    childReader.readToEnd();
                    continue;
                }
                childReader.readToEnd();
            }
            return object;
        }
        catch (IllegalAccessException e) {
            throw new DatabindingException("Illegal access. " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new DatabindingException("Couldn't instantiate class. " + e.getMessage(), e);
        }
        catch (SecurityException e) {
            throw new DatabindingException("Illegal access. " + e.getMessage(), e);
        }
        catch (IllegalArgumentException e) {
            throw new DatabindingException("Illegal argument. " + e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new DatabindingException("Could not create class: " + e.getMessage(), e);
        }
    }

    protected Object createFromFault(Context context) throws SecurityException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object o;
        Class clazz = this.getTypeClass();
        Fault fault = context.getFault();
        try {
            Constructor ctr = clazz.getConstructor(String.class, Throwable.class);
            o = ctr.newInstance(fault.getMessage(), fault);
        }
        catch (NoSuchMethodException e) {
            try {
                Constructor ctr = clazz.getConstructor(String.class, Exception.class);
                o = ctr.newInstance(fault.getMessage(), fault);
            }
            catch (NoSuchMethodException e1) {
                try {
                    Constructor ctr = clazz.getConstructor(String.class);
                    o = ctr.newInstance(fault.getMessage());
                }
                catch (NoSuchMethodException e2) {
                    return clazz.newInstance();
                }
            }
        }
        return o;
    }

    protected void writeProperty(QName name, Object object, Object property, Class impl, BeanTypeInfo inf) throws DatabindingException {
        try {
            PropertyDescriptor desc = inf.getPropertyDescriptorFromMappedName(name);
            Method m = desc.getWriteMethod();
            if (m == null) {
                if (this.getTypeClass().isInterface()) {
                    m = this.getWriteMethodFromImplClass(impl, desc);
                }
                if (m == null) {
                    throw new DatabindingException("No write method for property " + name + " in " + object.getClass());
                }
            }
            Class<?> propertyType = desc.getPropertyType();
            if (property == null && !propertyType.isPrimitive() || property != null) {
                m.invoke(object, property);
            }
        }
        catch (Exception e) {
            if (e instanceof DatabindingException) {
                throw (DatabindingException)e;
            }
            throw new DatabindingException("Couldn't set property " + name + " on " + object + ". " + e.getMessage(), e);
        }
    }

    private Method getWriteMethodFromImplClass(Class<?> impl, PropertyDescriptor pd) throws Exception {
        String name = pd.getName();
        name = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        return impl.getMethod(name, pd.getPropertyType());
    }

    void writeObjectFromObjectType(Object object, MessageWriter writer, Context context, boolean wroteXsiType) {
        this.writeObjectInternal(object, writer, context, wroteXsiType);
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        this.writeObjectInternal(object, writer, context, false);
    }

    private void writeObjectInternal(Object object, MessageWriter writer, Context context, boolean wroteXsiType) throws DatabindingException {
        BeanType t;
        Object value;
        QName name;
        if (object == null) {
            return;
        }
        BeanTypeInfo inf = this.getTypeInfo();
        if (!wroteXsiType && object.getClass() == this.getTypeClass() && context.isWriteXsiTypes()) {
            writer.writeXsiType(this.getSchemaType());
        }
        Iterator<QName> itr = inf.getAttributes();
        while (itr.hasNext()) {
            name = itr.next();
            value = this.readProperty(object, name);
            if (value == null) continue;
            Type type = this.getType(inf, name);
            if (type == null) {
                throw new DatabindingException("Couldn't find type for " + value.getClass() + " for property " + name);
            }
            MessageWriter cwriter = writer.getAttributeWriter(name);
            type.writeObject(value, cwriter, context);
            cwriter.close();
        }
        if (inf.isExtension() && (t = this.getSuperType()) != null) {
            ((Type)t).writeObject(object, writer, context);
        }
        itr = inf.getElements();
        while (itr.hasNext()) {
            MessageWriter cwriter;
            name = itr.next();
            if (inf.isExtension() && inf.getPropertyDescriptorFromMappedName(name).getReadMethod().getDeclaringClass() != inf.getTypeClass()) continue;
            value = this.readProperty(object, name);
            Type defaultType = this.getType(inf, name);
            Type type = TypeUtil.getWriteType(context, value, defaultType);
            if (value != null) {
                cwriter = this.getWriter(writer, name, type);
                if (type == null) {
                    throw new DatabindingException("Couldn't find type for " + value.getClass() + " for property " + name);
                }
                type.writeObject(value, cwriter, context);
                cwriter.close();
                continue;
            }
            if (!inf.isNillable(name)) continue;
            cwriter = this.getWriter(writer, name, type);
            cwriter.writeXsiNil();
            cwriter.close();
        }
    }

    private MessageWriter getWriter(MessageWriter writer, QName name, Type type) {
        MessageWriter cwriter = type.isAbstract() ? writer.getElementWriter(name) : writer.getElementWriter(name);
        return cwriter;
    }

    protected Object readProperty(Object object, QName name) {
        try {
            PropertyDescriptor desc = this.getTypeInfo().getPropertyDescriptorFromMappedName(name);
            Method m = desc.getReadMethod();
            if (m == null) {
                throw new DatabindingException("No read method for property " + name + " in class " + object.getClass().getName());
            }
            return m.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new DatabindingException("Couldn't get property " + name + " from bean " + object, e);
        }
    }

    @Override
    public void writeSchema(Element root) {
        String prefix;
        String nameWithPrefix;
        String nameNS;
        Type type;
        Element element;
        QName name;
        BeanTypeInfo inf = this.getTypeInfo();
        Element complex = new Element("complexType", "xsd", "http://www.w3.org/2001/XMLSchema");
        complex.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.addContent((Content)complex);
        BeanType sooperType = this.getSuperType();
        if ((inf.getTypeClass().getModifiers() & 0x400) != 0 && !inf.getTypeClass().isInterface()) {
            complex.setAttribute(new Attribute("abstract", "true"));
        }
        if (inf.isExtension() && sooperType != null) {
            Element complexContent = new Element("complexContent", "xsd", "http://www.w3.org/2001/XMLSchema");
            complex.addContent((Content)complexContent);
            complex = complexContent;
        }
        boolean isExtension = inf.isExtension();
        Element dummy = complex;
        if (isExtension && sooperType != null) {
            Element extension = new Element("extension", "xsd", "http://www.w3.org/2001/XMLSchema");
            complex.addContent((Content)extension);
            QName baseType = sooperType.getSchemaType();
            extension.setAttribute(new Attribute("base", this.getNameWithPrefix2(root, baseType.getNamespaceURI(), baseType.getLocalPart())));
            dummy = extension;
        }
        Element seq = null;
        Iterator<QName> itr = inf.getElements();
        while (itr.hasNext()) {
            name = itr.next();
            if (isExtension) {
                PropertyDescriptor pd = inf.getPropertyDescriptorFromMappedName(name);
                assert (pd.getReadMethod() != null && pd.getWriteMethod() != null);
                if (pd.getReadMethod().getDeclaringClass() != inf.getTypeClass()) continue;
            }
            if (seq == null) {
                seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
                dummy.addContent((Content)seq);
            }
            element = new Element("element", "xsd", "http://www.w3.org/2001/XMLSchema");
            seq.addContent((Content)element);
            type = this.getType(inf, name);
            nameNS = name.getNamespaceURI();
            nameWithPrefix = this.getNameWithPrefix(root, nameNS, name.getLocalPart());
            prefix = NamespaceHelper.getUniquePrefix(root, type.getSchemaType().getNamespaceURI());
            this.writeTypeReference(name, nameWithPrefix, element, type, prefix, root);
        }
        if (inf.isExtensibleElements()) {
            if (seq == null) {
                seq = new Element("sequence", "xsd", "http://www.w3.org/2001/XMLSchema");
                dummy.addContent((Content)seq);
            }
            seq.addContent((Content)this.createAnyElement());
        }
        itr = inf.getAttributes();
        while (itr.hasNext()) {
            name = itr.next();
            element = new Element("attribute", "xsd", "http://www.w3.org/2001/XMLSchema");
            dummy.addContent((Content)element);
            type = this.getType(inf, name);
            nameNS = name.getNamespaceURI();
            nameWithPrefix = this.getNameWithPrefix(root, nameNS, name.getLocalPart());
            prefix = NamespaceHelper.getUniquePrefix(root, type.getSchemaType().getNamespaceURI());
            element.setAttribute(new Attribute("name", nameWithPrefix));
            element.setAttribute(TypeUtil.createTypeAttribute(prefix, type, root));
        }
        if (inf.isExtensibleAttributes()) {
            dummy.addContent((Content)this.createAnyAttribute());
        }
    }

    static Attribute createTypeAttribute(String prefix, Type type, Element root) {
        String ns = type.getSchemaType().getNamespaceURI();
        if (!ns.equals(root.getAttributeValue("targetNamespace")) && !ns.equals("http://www.w3.org/2001/XMLSchema")) {
            List l = CastUtils.cast((List)root.getChildren("import", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema")));
            boolean found = false;
            for (Element e : l) {
                if (!ns.equals(e.getAttributeValue("namespace"))) continue;
                found = true;
            }
            if (!found) {
                Element element = new Element("import", "xsd", "http://www.w3.org/2001/XMLSchema");
                root.addContent(0, (Content)element);
                element.setAttribute("namespace", ns);
            }
        }
        return new Attribute("type", prefix + ':' + type.getSchemaType().getLocalPart());
    }

    private String getNameWithPrefix(Element root, String nameNS, String localName) {
        if (!nameNS.equals(this.getSchemaType().getNamespaceURI())) {
            Element rootElement = (Element)root.getParent();
            String prefix = null;
            if (rootElement != null) {
                prefix = NamespaceHelper.getUniquePrefix(rootElement, nameNS);
            }
            if (prefix == null || prefix.length() == 0) {
                prefix = NamespaceHelper.getUniquePrefix(root, nameNS);
            }
            return prefix + ":" + localName;
        }
        return localName;
    }

    private String getNameWithPrefix2(Element root, String nameNS, String localName) {
        String prefix = NamespaceHelper.getUniquePrefix(root, nameNS);
        if (prefix == null || prefix.length() == 0) {
            prefix = NamespaceHelper.getUniquePrefix(root, nameNS);
        }
        return prefix + ":" + localName;
    }

    private Type getType(BeanTypeInfo inf, QName name) {
        Type type = inf.getType(name);
        if (type == null) {
            throw new NullPointerException("Couldn't find type for" + name + " in class " + this.getTypeClass().getName());
        }
        return type;
    }

    private void writeTypeReference(QName name, String nameWithPrefix, Element element, Type type, String prefix, Element root) {
        if (type.isAbstract()) {
            element.setAttribute(new Attribute("name", nameWithPrefix));
            element.setAttribute(TypeUtil.createTypeAttribute(prefix, type, root));
            int minOccurs = this.getTypeInfo().getMinOccurs(name);
            if (minOccurs == 0) {
                element.setAttribute(new Attribute("minOccurs", Integer.valueOf(minOccurs).toString()));
            }
            if (this.getTypeInfo().isNillable(name)) {
                element.setAttribute(new Attribute("nillable", "true"));
            }
        } else {
            element.setAttribute(new Attribute("ref", prefix + ':' + type.getSchemaType().getLocalPart()));
        }
    }

    @Override
    public void setTypeClass(Class typeClass) {
        super.setTypeClass(typeClass);
        this.initTypeClass();
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public Set<Type> getDependencies() {
        BeanType sooperType;
        QName name;
        HashSet<Type> deps = new HashSet<Type>();
        BeanTypeInfo inf = this.getTypeInfo();
        Iterator<QName> itr = inf.getAttributes();
        while (itr.hasNext()) {
            name = itr.next();
            deps.add(inf.getType(name));
        }
        itr = inf.getElements();
        while (itr.hasNext()) {
            name = itr.next();
            if (inf.isExtension() && inf.getPropertyDescriptorFromMappedName(name).getReadMethod().getDeclaringClass() != inf.getTypeClass()) continue;
            deps.add(inf.getType(name));
        }
        if (inf.isExtension() && (sooperType = this.getSuperType()) != null) {
            deps.add(sooperType);
        }
        return deps;
    }

    private BeanType getBeanTypeWithProperty(QName name) {
        BeanType sooper = this;
        Type type = null;
        while (type == null && sooper != null) {
            type = sooper.getTypeInfo().getType(name);
            if (type != null) continue;
            sooper = sooper.getSuperType();
        }
        return sooper;
    }

    private BeanType getSuperType() {
        BeanTypeInfo inf = this.getTypeInfo();
        Class<?> c = inf.getTypeClass().getSuperclass();
        if (c != null && c != Object.class && c != Exception.class && c != RuntimeException.class) {
            TypeMapping tm = inf.getTypeMapping();
            BeanType superType = (BeanType)tm.getType(c);
            if (superType == null) {
                superType = (BeanType)this.getTypeMapping().getTypeCreator().createType(c);
                Class<?> cParent = c.getSuperclass();
                if (cParent != null && cParent != Object.class) {
                    superType.getTypeInfo().setExtension(true);
                }
                tm.register(superType);
            }
            return superType;
        }
        return null;
    }

    public BeanTypeInfo getTypeInfo() {
        if (this.info == null) {
            this.info = this.createTypeInfo();
        }
        this.info.initialize();
        return this.info;
    }

    public BeanTypeInfo createTypeInfo() {
        BeanTypeInfo inf = new BeanTypeInfo(this.getTypeClass(), this.getSchemaType().getNamespaceURI());
        inf.setTypeMapping(this.getTypeMapping());
        return inf;
    }

    private Element createAnyElement() {
        Element result = new Element("any", "xsd", "http://www.w3.org/2001/XMLSchema");
        result.setAttribute(new Attribute("minOccurs", "0"));
        result.setAttribute(new Attribute("maxOccurs", "unbounded"));
        return result;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(": [class=");
        Class c = this.getTypeClass();
        sb.append(c == null ? "<null>" : c.getName());
        sb.append(",\nQName=");
        QName q = this.getSchemaType();
        sb.append(q == null ? "<null>" : q.toString());
        sb.append(",\ninfo=");
        sb.append(this.getTypeInfo().toString());
        sb.append("]");
        return sb.toString();
    }

    private Element createAnyAttribute() {
        return new Element("anyAttribute", "xsd", "http://www.w3.org/2001/XMLSchema");
    }
}

