/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.AegisDatabinding;
import org.apache.cxf.aegis.databinding.XMLStreamDataReader;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.aegis.xml.stax.ElementWriter;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;
import org.apache.cxf.service.model.MessagePartInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamDataWriter
implements DataWriter<XMLStreamWriter> {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLStreamDataReader.class);
    private AegisDatabinding databinding;
    private Collection<Attachment> attachments;
    private Map<String, Object> properties;

    public XMLStreamDataWriter(AegisDatabinding databinding) {
        this.databinding = databinding;
    }

    public void setAttachments(Collection<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void setSchema(Schema s) {
    }

    public void write(Object obj, MessagePartInfo part, XMLStreamWriter output) {
        Type type = this.databinding.getType(part);
        if (type == null) {
            throw new Fault(new Message("NO_MESSAGE_FOR_PART", LOG, new Object[0]));
        }
        Object props = (Endpoint)this.getProperty(ENDPOINT);
        if (props == null) {
            props = new HashMap();
        }
        Context context = new Context((Map<String, Object>)props);
        context.setTypeMapping(type.getTypeMapping());
        context.setOverrideTypes(CastUtils.cast((List)this.databinding.getOverrideTypes(), String.class));
        context.setAttachments(this.attachments);
        Object val = this.databinding.getService().get((Object)"writeXsiType");
        if ("true".equals(val) || Boolean.TRUE.equals(val)) {
            context.setWriteXsiTypes(true);
        }
        type = TypeUtil.getWriteType(context, obj, type);
        try {
            ElementWriter writer = new ElementWriter(output);
            MessageWriter w2 = writer.getElementWriter(part.getConcreteName());
            if (type.isNillable() && type.isWriteOuter() && obj == null) {
                w2.writeXsiNil();
                return;
            }
            type.writeObject(obj, w2, context);
            w2.close();
        }
        catch (DatabindingException e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Object obj, XMLStreamWriter output) {
        this.write(obj, null, output);
    }

    public void setProperty(String prop, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(prop, value);
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }
}

