/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.common.util.Base64Utility;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectType
extends Type {
    private static final QName XSI_TYPE = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
    private static final QName XSI_NIL = new QName("http://www.w3.org/2001/XMLSchema-instance", "nil");
    private Set<Type> dependencies;
    private boolean serializedWhenUnknown;
    private boolean readToDocument;

    public ObjectType() {
        this(Collections.EMPTY_SET);
        this.readToDocument = true;
    }

    public ObjectType(Set<Type> dependencies) {
        this(dependencies, false);
    }

    public ObjectType(boolean serializeWhenUnknown) {
        this(Collections.EMPTY_SET, serializeWhenUnknown);
    }

    public ObjectType(Set<Type> dependencies, boolean serializeWhenUnknown) {
        this.dependencies = dependencies;
        this.serializedWhenUnknown = serializeWhenUnknown;
    }

    @Override
    public Object readObject(MessageReader reader, Context context) throws DatabindingException {
        if (this.isNil(reader.getAttributeReader(XSI_NIL))) {
            while (reader.hasMoreElementReaders()) {
                reader.getNextElementReader();
            }
            return null;
        }
        MessageReader typeReader = reader.getAttributeReader(XSI_TYPE);
        if (null == typeReader && !this.readToDocument) {
            throw new DatabindingException("Missing 'xsi:type' attribute");
        }
        String typeName = typeReader.getValue();
        if (null == typeName && !this.readToDocument) {
            throw new DatabindingException("Missing 'xsi:type' attribute value");
        }
        Type type = null;
        QName typeQName = null;
        typeQName = typeName != null ? this.extractQName(reader, typeName) : reader.getName();
        TypeMapping tm = context.getTypeMapping();
        if (tm == null) {
            tm = this.getTypeMapping();
        }
        if ((type = tm.getType(typeQName)) == null) {
            type = tm.getType(this.getSchemaType());
        }
        if (type == this) {
            throw new DatabindingException("Could not determine how to read type: " + typeQName);
        }
        if (type == null && this.readToDocument) {
            type = this.getTypeMapping().getType(Document.class);
        }
        if (null == type) {
            if (this.serializedWhenUnknown && "serializedJavaObject".equals(typeName)) {
                return this.reconstituteJavaObject(reader);
            }
            throw new DatabindingException("No mapped type for '" + typeName + "' (" + typeQName + ")");
        }
        return type.readObject(reader, context);
    }

    private QName extractQName(MessageReader reader, String typeName) {
        int colon = typeName.indexOf(58);
        if (-1 == colon) {
            return new QName(reader.getNamespace(), typeName);
        }
        return new QName(reader.getNamespaceForPrefix(typeName.substring(0, colon)), typeName.substring(colon + 1));
    }

    private Object reconstituteJavaObject(MessageReader reader) throws DatabindingException {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(Base64Utility.decode((String)reader.getValue()));
            return new ObjectInputStream(in).readObject();
        }
        catch (Exception e) {
            throw new DatabindingException("Unable to reconstitute serialized object", e);
        }
    }

    private boolean isNil(MessageReader reader) {
        return null != reader && "true".equals(reader.getValue());
    }

    @Override
    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        if (null == object) {
            MessageWriter nilWriter = writer.getAttributeWriter(XSI_NIL);
            nilWriter.writeValue("true");
            nilWriter.close();
        } else {
            String prefix;
            Type type = this.determineType(context, object.getClass());
            if (null == type) {
                TypeMapping tm = context.getTypeMapping();
                if (tm == null) {
                    tm = this.getTypeMapping();
                }
                type = tm.getTypeCreator().createType(object.getClass());
                tm.register(type);
            }
            if (null == (prefix = writer.getPrefixForNamespace(type.getSchemaType().getNamespaceURI())) || prefix.length() == 0) {
                this.addXsiType(writer, type.getSchemaType().getLocalPart());
            } else {
                this.addXsiType(writer, prefix + ":" + type.getSchemaType().getLocalPart());
            }
            type.writeObject(object, writer, context);
        }
    }

    private Type determineType(Context context, Class clazz) {
        Type type;
        TypeMapping tm = context.getTypeMapping();
        if (tm == null) {
            tm = this.getTypeMapping();
        }
        if (null != (type = tm.getType(clazz))) {
            return type;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> anInterface = interfaces[i];
            type = tm.getType(anInterface);
            if (null == type) continue;
            return type;
        }
        Class superclass = clazz.getSuperclass();
        if (null == superclass || Object.class.equals(superclass)) {
            return null;
        }
        return this.determineType(context, superclass);
    }

    private void addXsiType(MessageWriter writer, String prefixedType) {
        MessageWriter typeWriter = writer.getAttributeWriter(XSI_TYPE);
        typeWriter.writeValue(prefixedType);
        typeWriter.close();
    }

    public boolean isReadToDocument() {
        return this.readToDocument;
    }

    public void setReadToDocument(boolean readToDocument) {
        this.readToDocument = readToDocument;
    }

    public boolean isSerializedWhenUnknown() {
        return this.serializedWhenUnknown;
    }

    public void setSerializedWhenUnknown(boolean serializedWhenUnknown) {
        this.serializedWhenUnknown = serializedWhenUnknown;
    }

    public void setDependencies(Set<Type> dependencies) {
        this.dependencies = dependencies;
    }

    @Override
    public Set<Type> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean isAbstract() {
        return super.isAbstract();
    }

    @Override
    public boolean isNillable() {
        return super.isNillable();
    }

    @Override
    public boolean isWriteOuter() {
        return super.isWriteOuter();
    }

    @Override
    public void setNillable(boolean nillable) {
        super.setNillable(nillable);
    }

    @Override
    public void writeSchema(Element root) {
        if (this.serializedWhenUnknown) {
            Element simple = new Element("simpleType", "xsd", "http://www.w3.org/2001/XMLSchema");
            simple.setAttribute(new Attribute("name", "serializedJavaObject"));
            root.addContent((Content)simple);
            Element restriction = new Element("restriction", "xsd", "http://www.w3.org/2001/XMLSchema");
            restriction.setAttribute(new Attribute("base", "xsd:base64Binary"));
            simple.addContent((Content)restriction);
        }
    }
}

