/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.xml.stax;

import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.xml.AbstractMessageReader;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.stax.AttributeReader;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;

public class ElementReader
extends AbstractMessageReader
implements MessageReader {
    private static final Pattern QNAME_PATTERN = Pattern.compile("([^:]+):([^:]+)");
    private DepthXMLStreamReader root;
    private String value;
    private String localName;
    private QName name;
    private QName xsiType;
    private boolean hasCheckedChildren;
    private boolean hasChildren;
    private String namespace;
    private int depth;
    private int currentAttribute;

    public ElementReader(DepthXMLStreamReader root) {
        this.root = root;
        this.localName = root.getLocalName();
        this.name = root.getName();
        this.namespace = root.getNamespaceURI();
        this.extractXsiType();
        this.depth = root.getDepth();
    }

    public ElementReader(XMLStreamReader reader) {
        this(reader instanceof DepthXMLStreamReader ? (DepthXMLStreamReader)reader : new DepthXMLStreamReader(reader));
    }

    public ElementReader(InputStream is) throws XMLStreamException {
        XMLStreamReader xmlReader = StaxUtils.createXMLStreamReader((InputStream)is, null);
        xmlReader.nextTag();
        this.root = new DepthXMLStreamReader(xmlReader);
        this.localName = this.root.getLocalName();
        this.name = this.root.getName();
        this.namespace = this.root.getNamespaceURI();
        this.extractXsiType();
        this.depth = this.root.getDepth();
    }

    private void extractXsiType() {
        String xsiTypeQname = this.root.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (xsiTypeQname != null) {
            Matcher m = QNAME_PATTERN.matcher(xsiTypeQname);
            if (m.matches()) {
                NamespaceContext nc = this.root.getNamespaceContext();
                this.xsiType = new QName(nc.getNamespaceURI(m.group(1)), m.group(2), m.group(1));
            } else {
                this.xsiType = new QName(this.namespace, xsiTypeQname, "");
            }
        }
    }

    public String getValue() {
        if (this.value == null) {
            try {
                this.value = this.root.getElementText();
                this.hasCheckedChildren = true;
                this.hasChildren = false;
                if (this.root.hasNext()) {
                    this.root.next();
                }
            }
            catch (XMLStreamException e) {
                throw new DatabindingException("Could not read XML stream.", e);
            }
            this.value = this.value == null ? "" : this.value.trim();
        }
        return this.value;
    }

    public String getValue(String ns, String attr) {
        return this.root.getAttributeValue(ns, attr);
    }

    public boolean hasMoreElementReaders() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        return this.hasChildren;
    }

    private boolean checkHasMoreChildReaders() {
        try {
            int event = this.root.getEventType();
            while (this.root.hasNext()) {
                switch (event) {
                    case 1: {
                        if (this.root.getDepth() <= this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = true;
                        return true;
                    }
                    case 2: {
                        if (this.root.getDepth() >= this.depth) break;
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        if (this.root.hasNext()) {
                            this.root.next();
                        }
                        return false;
                    }
                    case 8: {
                        this.hasCheckedChildren = true;
                        this.hasChildren = false;
                        return false;
                    }
                }
                if (!this.root.hasNext()) continue;
                event = this.root.next();
            }
            this.hasCheckedChildren = true;
            this.hasChildren = false;
            return false;
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Error parsing document.", e);
        }
    }

    public MessageReader getNextElementReader() {
        if (!this.hasCheckedChildren) {
            this.checkHasMoreChildReaders();
        }
        if (!this.hasChildren) {
            return null;
        }
        this.hasCheckedChildren = false;
        return new ElementReader(this.root);
    }

    public QName getName() {
        return this.name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public QName getXsiType() {
        return this.xsiType;
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.root;
    }

    public boolean hasMoreAttributeReaders() {
        if (!this.root.isStartElement()) {
            return false;
        }
        return this.currentAttribute < this.root.getAttributeCount();
    }

    public MessageReader getAttributeReader(QName qName) {
        return new AttributeReader(qName, this.root.getAttributeValue(qName.getNamespaceURI(), qName.getLocalPart()));
    }

    public MessageReader getNextAttributeReader() {
        AttributeReader reader = new AttributeReader(this.root.getAttributeName(this.currentAttribute), this.root.getAttributeValue(this.currentAttribute));
        ++this.currentAttribute;
        return reader;
    }

    public String getNamespaceForPrefix(String prefix) {
        return this.root.getNamespaceURI(prefix);
    }
}

