/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.databinding;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.databinding.ElementDataReader;
import org.apache.cxf.aegis.databinding.ElementDataWriter;
import org.apache.cxf.aegis.databinding.XMLStreamDataReader;
import org.apache.cxf.aegis.databinding.XMLStreamDataWriter;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeCreationOptions;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.aegis.type.mtom.AbstractXOPType;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.databinding.AbstractDataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.frontend.SimpleMethodDispatcher;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.AbstractMessageContainer;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.jaxen.JaxenException;
import org.jaxen.jdom.JDOMXPath;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.output.DOMOutputter;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AegisDatabinding
extends AbstractDataBinding {
    public static final String WRITE_XSI_TYPE_KEY = "writeXsiType";
    public static final String OVERRIDE_TYPES_KEY = "overrideTypesList";
    public static final String READ_XSI_TYPE_KEY = "readXsiType";
    protected static final int IN_PARAM = 0;
    protected static final int OUT_PARAM = 1;
    protected static final int FAULT_PARAM = 2;
    private static final Logger LOG = LogUtils.getL7dLogger(AegisDatabinding.class);
    private static org.w3c.dom.Document xmimeSchemaDocument;
    private AegisContext aegisContext;
    private Map<MessagePartInfo, Type> part2Type = new HashMap<MessagePartInfo, Type>();
    private Service service;
    private boolean isInitialized;
    private Set<String> overrideTypes;
    private TypeCreationOptions configuration;
    private boolean mtomEnabled;
    private boolean mtomUseXmime;
    private JDOMXPath importXmimeXpath = AbstractXOPType.getXmimeXpathImport();

    private boolean schemaImportsXmime(Element schemaElement) {
        try {
            return this.importXmimeXpath.selectSingleNode((Object)schemaElement) != null;
        }
        catch (JaxenException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureXmimeSchemaDocument() {
        if (xmimeSchemaDocument != null) {
            return;
        }
        try {
            xmimeSchemaDocument = DOMUtils.readXml((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/schemas/wsdl/xmime.xsd"));
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private void ensureInitialized() {
        if (!this.isInitialized) {
            if (this.aegisContext == null) {
                this.aegisContext = new AegisContext();
                if (this.overrideTypes != null) {
                    this.aegisContext.setRootClassNames(this.overrideTypes);
                }
                if (this.configuration != null) {
                    this.aegisContext.setTypeCreationOptions(this.configuration);
                }
                if (this.mtomEnabled) {
                    this.aegisContext.setMtomEnabled(true);
                }
                if (this.mtomUseXmime) {
                    this.aegisContext.setMtomUseXmime(true);
                }
                this.aegisContext.initialize();
            }
            this.isInitialized = true;
        }
    }

    public <T> DataReader<T> createReader(Class<T> cls) {
        this.ensureInitialized();
        if (cls.equals(XMLStreamReader.class)) {
            return new XMLStreamDataReader(this);
        }
        if (cls.equals(Node.class)) {
            return new ElementDataReader(this);
        }
        throw new UnsupportedOperationException();
    }

    public <T> DataWriter<T> createWriter(Class<T> cls) {
        this.ensureInitialized();
        if (cls.equals(XMLStreamWriter.class)) {
            return new XMLStreamDataWriter(this);
        }
        if (cls.equals(Node.class)) {
            return new ElementDataWriter(this);
        }
        throw new UnsupportedOperationException();
    }

    public Class<?>[] getSupportedReaderFormats() {
        return new Class[]{XMLStreamReader.class, Node.class};
    }

    public Class<?>[] getSupportedWriterFormats() {
        return new Class[]{XMLStreamWriter.class, Node.class};
    }

    public void initialize(Service s) {
        if (this.aegisContext == null) {
            this.aegisContext = new AegisContext();
            Object val = s.get((Object)READ_XSI_TYPE_KEY);
            if ("false".equals(val) || Boolean.FALSE.equals(val)) {
                this.aegisContext.setReadXsiTypes(false);
            }
            if ("true".equals(val = s.get((Object)WRITE_XSI_TYPE_KEY)) || Boolean.TRUE.equals(val)) {
                this.aegisContext.setWriteXsiTypes(true);
            }
            if ((val = s.get((Object)OVERRIDE_TYPES_KEY)) != null) {
                Collection nameCollection = (Collection)val;
                Collection typeNames = CastUtils.cast((Collection)nameCollection, String.class);
                if (this.overrideTypes == null) {
                    this.overrideTypes = new HashSet<String>();
                }
                this.overrideTypes.addAll(typeNames);
            }
            if ("true".equals(val = s.get((Object)"mtom-enabled")) || Boolean.TRUE.equals(val) || this.mtomEnabled) {
                this.aegisContext.setMtomEnabled(true);
            }
            if (this.mtomUseXmime) {
                this.aegisContext.setMtomUseXmime(true);
            }
            HashMap implMap = new HashMap();
            for (String key : s.keySet()) {
                if (!key.endsWith(".implementation")) continue;
                String className = key.substring(0, key.length() - ".implementation".length());
                Class clazz = null;
                try {
                    clazz = ClassLoaderUtils.loadClass((String)className, ((Object)((Object)this)).getClass());
                }
                catch (ClassNotFoundException e) {
                    Message message = new Message("MAPPED_CLASS_NOT_FOUND", LOG, new Object[]{className, key});
                    LOG.warning(message.toString());
                    continue;
                }
                String implClassName = (String)s.get((Object)key);
                implMap.put(clazz, implClassName);
            }
            if (this.overrideTypes != null) {
                this.aegisContext.setRootClassNames(this.overrideTypes);
            }
            if (this.configuration != null) {
                this.aegisContext.setTypeCreationOptions(this.configuration);
            }
            if (implMap.size() > 0) {
                this.aegisContext.setBeanImplementationMap(implMap);
            }
        }
        this.aegisContext.setMappingNamespaceURI(((ServiceInfo)s.getServiceInfos().get(0)).getName().getNamespaceURI());
        this.aegisContext.initialize();
        this.service = s;
        HashSet<Type> deps = new HashSet<Type>();
        for (ServiceInfo info : s.getServiceInfos()) {
            for (OperationInfo opInfo : info.getInterface().getOperations()) {
                if (opInfo.isUnwrappedCapable()) {
                    this.initializeOperation(s, this.aegisContext.getTypeMapping(), opInfo.getUnwrappedOperation(), deps);
                    continue;
                }
                this.initializeOperation(s, this.aegisContext.getTypeMapping(), opInfo, deps);
            }
        }
        Set<Type> additional = this.aegisContext.getRootTypes();
        if (additional != null) {
            for (Type t : additional) {
                if (!deps.contains(t)) {
                    deps.add(t);
                }
                this.addDependencies(deps, t);
            }
        }
        this.createSchemas(s, deps);
        for (ServiceInfo info : s.getServiceInfos()) {
            for (OperationInfo opInfo : info.getInterface().getOperations()) {
                if (opInfo.isUnwrappedCapable()) {
                    this.initializeOperationTypes(info, opInfo.getUnwrappedOperation());
                    continue;
                }
                this.initializeOperationTypes(info, opInfo);
            }
        }
    }

    private void initializeOperation(Service s, TypeMapping serviceTM, OperationInfo opInfo, Set<Type> deps) {
        try {
            this.initializeMessage(s, serviceTM, (AbstractMessageContainer)opInfo.getInput(), 0, deps);
            if (opInfo.hasOutput()) {
                this.initializeMessage(s, serviceTM, (AbstractMessageContainer)opInfo.getOutput(), 1, deps);
            }
            for (FaultInfo info : opInfo.getFaults()) {
                this.initializeMessage(s, serviceTM, (AbstractMessageContainer)info, 2, deps);
            }
        }
        catch (DatabindingException e) {
            e.prepend("Error initializing parameters for operation " + opInfo.getName());
            throw e;
        }
    }

    private void initializeOperationTypes(ServiceInfo s, OperationInfo opInfo) {
        try {
            this.initializeMessageTypes(s, (AbstractMessageContainer)opInfo.getInput(), 0);
            if (opInfo.hasOutput()) {
                this.initializeMessageTypes(s, (AbstractMessageContainer)opInfo.getOutput(), 1);
            }
            for (FaultInfo info : opInfo.getFaults()) {
                this.initializeMessageTypes(s, (AbstractMessageContainer)info, 2);
            }
        }
        catch (DatabindingException e) {
            e.prepend("Error initializing parameters for operation " + opInfo.getName());
            throw e;
        }
    }

    protected void initializeMessage(Service s, TypeMapping serviceTM, AbstractMessageContainer container, int partType, Set<Type> deps) {
        for (MessagePartInfo part : container.getMessageParts()) {
            long mo;
            long miValue;
            Type type = this.getParameterType(s, serviceTM, part, partType);
            if (part.getXmlSchema() == null) {
                if (type.isAbstract()) {
                    part.setTypeQName(type.getSchemaType());
                } else {
                    part.setElementQName(type.getSchemaType());
                }
            }
            part.setProperty("nillable", (Object)type.isNillable());
            if (type.hasMinOccurs() && (miValue = type.getMinOccurs()) != 0L) {
                part.setProperty("minOccurs", (Object)Long.toString(miValue));
            }
            if (type.hasMaxOccurs() && (mo = type.getMaxOccurs()) != Long.MAX_VALUE) {
                String moValue = Long.toString(mo);
                part.setProperty("maxOccurs", (Object)moValue);
            }
            this.part2Type.put(part, type);
            deps.add(type);
            this.addDependencies(deps, type);
        }
    }

    protected void initializeMessageTypes(ServiceInfo s, AbstractMessageContainer container, int partType) {
        SchemaCollection col = s.getXmlSchemaCollection();
        for (MessagePartInfo part : container.getMessageParts()) {
            XmlSchemaElement tp;
            if (part.getXmlSchema() != null) continue;
            if (part.isElement()) {
                tp = col.getElementByQName(part.getElementQName());
                part.setXmlSchema((XmlSchemaAnnotated)tp);
                continue;
            }
            tp = col.getTypeByQName(part.getTypeQName());
            part.setXmlSchema((XmlSchemaAnnotated)tp);
        }
    }

    private void addDependencies(Set<Type> deps, Type type) {
        Set<Type> typeDeps = type.getDependencies();
        if (typeDeps != null) {
            for (Type t : typeDeps) {
                if (deps.contains(t)) continue;
                deps.add(t);
                this.addDependencies(deps, t);
            }
        }
    }

    private void createSchemas(Service s, Set<Type> deps) {
        HashMap<String, HashSet<Type>> tns2Type = new HashMap<String, HashSet<Type>>();
        for (Type t : deps) {
            String ns = t.getSchemaType().getNamespaceURI();
            HashSet<Type> types = (HashSet<Type>)tns2Type.get(ns);
            if (types == null) {
                types = new HashSet<Type>();
                tns2Type.put(ns, types);
            }
            types.add(t);
        }
        for (ServiceInfo si : s.getServiceInfos()) {
            SchemaCollection col = si.getXmlSchemaCollection();
            if (col.getXmlSchemas().length <= 1) continue;
        }
        Map namespaceMap = this.getDeclaredNamespaceMappings();
        boolean needXmimeSchema = false;
        boolean needTypesSchema = false;
        for (Map.Entry entry : tns2Type.entrySet()) {
            String xsdPrefix = "xsd";
            if (namespaceMap != null && namespaceMap.containsKey("http://www.w3.org/2001/XMLSchema")) {
                xsdPrefix = (String)namespaceMap.get("http://www.w3.org/2001/XMLSchema");
            }
            Element e = new Element("schema", xsdPrefix, "http://www.w3.org/2001/XMLSchema");
            e.setAttribute(new Attribute("targetNamespace", (String)entry.getKey()));
            if (null != namespaceMap) {
                for (Map.Entry mapping : namespaceMap.entrySet()) {
                    e.addNamespaceDeclaration(Namespace.getNamespace((String)((String)mapping.getValue()), (String)((String)mapping.getKey())));
                }
            }
            if (namespaceMap == null || !namespaceMap.containsKey(entry.getKey())) {
                e.addNamespaceDeclaration(Namespace.getNamespace((String)"tns", (String)((String)entry.getKey())));
            }
            e.setAttribute(new Attribute("elementFormDefault", "qualified"));
            e.setAttribute(new Attribute("attributeFormDefault", "qualified"));
            for (Type t : (Set)entry.getValue()) {
                t.writeSchema(e);
            }
            if (e.getChildren().size() == 0) continue;
            if (this.schemaImportsXmime(e)) {
                needXmimeSchema = true;
            }
            if (AegisContext.schemaImportsUtilityTypes(e)) {
                needTypesSchema = true;
            }
            try {
                NamespaceMap nsMap = new NamespaceMap();
                nsMap.add(xsdPrefix, "http://www.w3.org/2001/XMLSchema");
                for (Namespace n : e.getAdditionalNamespaces()) {
                    if (nsMap.containsValue((Object)n.getURI())) continue;
                    nsMap.add(n.getPrefix(), n.getURI());
                }
                org.w3c.dom.Document schema = new DOMOutputter().output(new Document(e));
                for (ServiceInfo si : s.getServiceInfos()) {
                    SchemaCollection col = si.getXmlSchemaCollection();
                    col.setNamespaceContext((NamespacePrefixList)nsMap);
                    XmlSchema xmlSchema = this.addSchemaDocument(si, col, schema, (String)entry.getKey());
                    xmlSchema.setNamespaceContext((NamespacePrefixList)nsMap);
                }
            }
            catch (JDOMException e1) {
                throw new ServiceConstructionException((Throwable)e1);
            }
        }
        if (needXmimeSchema) {
            this.ensureXmimeSchemaDocument();
            for (ServiceInfo si : s.getServiceInfos()) {
                SchemaCollection col = si.getXmlSchemaCollection();
                this.addSchemaDocument(si, col, xmimeSchemaDocument, "http://www.w3.org/2005/05/xmlmime");
            }
        }
        if (needTypesSchema) {
            org.w3c.dom.Document schema = this.aegisContext.getTypesSchemaDocument();
            for (ServiceInfo si : s.getServiceInfos()) {
                SchemaCollection col = si.getXmlSchemaCollection();
                this.addSchemaDocument(si, col, schema, "http://cxf.apache.org/aegisTypes");
            }
        }
    }

    public QName getSuggestedName(Service s, TypeMapping tm, OperationInfo op, int param) {
        Type type;
        Method m = this.getMethod(s, op);
        if (m == null) {
            return null;
        }
        QName name = tm.getTypeCreator().getElementName(m, param);
        if (name == null && (type = tm.getTypeCreator().createType(m, param)).isComplex() && !type.isAbstract()) {
            name = type.getSchemaType();
        }
        return name;
    }

    private Type getParameterType(Service s, TypeMapping tm, MessagePartInfo param, int paramtype) {
        Type type = tm.getType(param.getTypeQName());
        int offset = 0;
        if (paramtype == 1) {
            offset = 1;
        }
        TypeCreator typeCreator = tm.getTypeCreator();
        if (type == null) {
            OperationInfo op = param.getMessageInfo().getOperation();
            Method m = this.getMethod(s, op);
            AbstractTypeCreator.TypeClassInfo info = paramtype != 2 && m != null ? typeCreator.createClassInfo(m, param.getIndex() - offset) : typeCreator.createBasicClassInfo(param.getTypeClass());
            if (param.getMessageInfo().getOperation().isUnwrapped() && param.getTypeClass().isArray()) {
                param.setProperty("minOccurs", (Object)"1");
                param.setProperty("maxOccurs", (Object)"1");
                param.setProperty("nillable", (Object)Boolean.TRUE);
            }
            if (info.getMappedName() != null) {
                param.setConcreteName(info.getMappedName());
                param.setName(info.getMappedName());
            }
            type = typeCreator.createTypeForClass(info);
            if (info.nonDefaultAttributes()) {
                tm.register(type);
            }
            type.setTypeMapping(tm);
            this.part2Type.put(param, type);
        }
        return type;
    }

    private Method getMethod(Service s, OperationInfo op) {
        MethodDispatcher md = (MethodDispatcher)s.get((Object)MethodDispatcher.class.getName());
        SimpleMethodDispatcher smd = (SimpleMethodDispatcher)md;
        return smd.getPrimaryMethod(op);
    }

    public Type getType(MessagePartInfo part) {
        return this.part2Type.get(part);
    }

    public Service getService() {
        return this.service;
    }

    public AegisContext getAegisContext() {
        this.ensureInitialized();
        return this.aegisContext;
    }

    public void setAegisContext(AegisContext aegisContext) {
        this.aegisContext = aegisContext;
    }

    public void setOverrideTypes(Set<String> types) {
        this.overrideTypes = types;
    }

    public void setConfiguration(TypeCreationOptions configuration) {
        this.configuration = configuration;
    }

    public boolean isMtomEnabled() {
        return this.mtomEnabled;
    }

    public void setMtomEnabled(boolean mtomEnabled) {
        this.mtomEnabled = mtomEnabled;
    }

    public boolean isMtomUseXmime() {
        return this.mtomUseXmime;
    }

    public void setMtomUseXmime(boolean mtomUseXmime) {
        this.mtomUseXmime = mtomUseXmime;
    }
}

