/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type;

import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.basic.XMLBeanTypeInfo;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.XPathUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLTypeCreator
extends AbstractTypeCreator {
    private static final Logger LOG = LogUtils.getL7dLogger(XMLTypeCreator.class);
    private static List<Class> stopClasses = new ArrayList<Class>();
    private static DocumentBuilderFactory aegisDocumentBuilderFactory;
    private static Schema aegisSchema;
    private Map<String, Document> documents = new HashMap<String, Document>();
    private XPathUtils xpathUtils = new XPathUtils();

    private Document readAegisFile(InputStream is, final String path) throws IOException {
        Document doc;
        DocumentBuilder documentBuilder;
        try {
            documentBuilder = aegisDocumentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            LOG.log(Level.SEVERE, "Unable to create a document builder, e");
            throw new RuntimeException("Unable to create a document builder, e");
        }
        documentBuilder.setErrorHandler(new ErrorHandler(){

            private String errorMessage(SAXParseException exception) {
                return MessageFormat.format("{0} at {1} line {2} column {3}.", exception.getMessage(), path, exception.getLineNumber(), exception.getColumnNumber());
            }

            private void throwDatabindingException(String message) {
                DatabindingException e = new DatabindingException(message);
                e.setMessage(message);
                throw e;
            }

            public void error(SAXParseException exception) throws SAXException {
                String message = this.errorMessage(exception);
                LOG.log(Level.SEVERE, message, exception);
                this.throwDatabindingException(message);
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                String message = this.errorMessage(exception);
                LOG.log(Level.SEVERE, message, exception);
                this.throwDatabindingException(message);
            }

            public void warning(SAXParseException exception) throws SAXException {
                LOG.log(Level.INFO, this.errorMessage(exception), exception);
            }
        });
        try {
            doc = documentBuilder.parse(is);
        }
        catch (SAXException e) {
            LOG.log(Level.SEVERE, "Error parsing Aegis file.", e);
            return null;
        }
        return doc;
    }

    protected Document getDocument(Class clazz) {
        if (clazz == null) {
            return null;
        }
        Document doc = this.documents.get(clazz.getName());
        if (doc != null) {
            return doc;
        }
        String path = '/' + clazz.getName().replace('.', '/') + ".aegis.xml";
        InputStream is = clazz.getResourceAsStream(path);
        if (is == null) {
            LOG.finest("Mapping file : " + path + " not found.");
            return null;
        }
        LOG.finest("Found mapping file : " + path);
        try {
            doc = this.readAegisFile(is, path);
            this.documents.put(clazz.getName(), doc);
            return doc;
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Error loading file " + path, e);
            return null;
        }
    }

    @Override
    protected boolean isEnum(Class javaType) {
        Element mapping = this.findMapping(javaType);
        if (mapping != null) {
            return super.isEnum(javaType);
        }
        return this.nextCreator.isEnum(javaType);
    }

    @Override
    public Type createEnumType(TypeClassInfo info) {
        Element mapping = this.findMapping(info.getTypeClass());
        if (mapping != null) {
            return super.createEnumType(info);
        }
        return this.nextCreator.createEnumType(info);
    }

    @Override
    public Type createCollectionType(TypeClassInfo info) {
        if (info.getGenericType() instanceof Class || info.getGenericType() instanceof TypeClassInfo) {
            return this.createCollectionTypeFromGeneric(info);
        }
        return this.nextCreator.createCollectionType(info);
    }

    @Override
    public TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        Element mapping = this.findMapping(pd.getReadMethod().getDeclaringClass());
        if (mapping == null) {
            return this.nextCreator.createClassInfo(pd);
        }
        Element propertyEl = this.getMatch(mapping, "./property[@name='" + pd.getName() + "']");
        if (propertyEl == null) {
            return this.nextCreator.createClassInfo(pd);
        }
        TypeClassInfo info = new TypeClassInfo();
        info.setTypeClass(pd.getReadMethod().getReturnType());
        info.setDescription("property " + pd.getDisplayName());
        this.readMetadata(info, mapping, propertyEl);
        return info;
    }

    protected Element findMapping(Class clazz) {
        Document doc = this.getDocument(clazz);
        if (doc == null) {
            return null;
        }
        Element mapping = this.getMatch(doc, "/mappings/mapping[@uri='" + this.getTypeMapping().getMappingIdentifierURI() + "']");
        if (mapping == null) {
            mapping = this.getMatch(doc, "/mappings/mapping[not(@uri)]");
        }
        return mapping;
    }

    protected List<Element> findMappings(Class clazz) {
        ArrayList<Element> mappings = new ArrayList<Element>();
        Element top = this.findMapping(clazz);
        if (top != null) {
            mappings.add(top);
        }
        Class parent = clazz;
        while (true) {
            Class<?>[] interfaces = parent.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Class<?> interfaze = interfaces[i];
                List<Element> interfaceMappings = this.findMappings(interfaze);
                mappings.addAll(interfaceMappings);
            }
            Class sup = parent.getSuperclass();
            if (sup == null || stopClasses.contains(sup)) break;
            Element mapping = this.findMapping(sup);
            if (mapping != null) {
                mappings.add(mapping);
            }
            parent = sup;
        }
        return mappings;
    }

    @Override
    public Type createDefaultType(TypeClassInfo info) {
        Element mapping = this.findMapping(info.getTypeClass());
        List<Element> mappings = this.findMappings(info.getTypeClass());
        if (mapping != null || mappings.size() > 0) {
            String typeNameAtt = null;
            if (mapping != null) {
                typeNameAtt = DOMUtils.getAttributeValueEmptyNull((Element)mapping, (String)"name");
            }
            String extensibleElements = null;
            if (mapping != null) {
                extensibleElements = mapping.getAttribute("extensibleElements");
            }
            String extensibleAttributes = null;
            if (mapping != null) {
                extensibleAttributes = mapping.getAttribute("extensibleAttributes");
            }
            String defaultNS = NamespaceHelper.makeNamespaceFromClassName(info.getTypeClass().getName(), "http");
            QName name = null;
            if (typeNameAtt != null) {
                name = NamespaceHelper.createQName(mapping, typeNameAtt, defaultNS);
                defaultNS = name.getNamespaceURI();
            }
            XMLBeanTypeInfo btinfo = new XMLBeanTypeInfo(info.getTypeClass(), mappings, defaultNS);
            btinfo.setTypeMapping(this.getTypeMapping());
            btinfo.setDefaultMinOccurs(this.getConfiguration().getDefaultMinOccurs());
            btinfo.setDefaultNillable(this.getConfiguration().isDefaultNillable());
            if (extensibleElements != null) {
                btinfo.setExtensibleElements(Boolean.valueOf(extensibleElements));
            } else {
                btinfo.setExtensibleElements(this.getConfiguration().isDefaultExtensibleElements());
            }
            if (extensibleAttributes != null) {
                btinfo.setExtensibleAttributes(Boolean.valueOf(extensibleAttributes));
            } else {
                btinfo.setExtensibleAttributes(this.getConfiguration().isDefaultExtensibleAttributes());
            }
            btinfo.setQualifyAttributes(this.getConfiguration().isQualifyAttributes());
            btinfo.setQualifyElements(this.getConfiguration().isQualifyElements());
            BeanType type = new BeanType(btinfo);
            if (name == null) {
                name = this.createQName(info.getTypeClass());
            }
            type.setSchemaType(name);
            type.setTypeClass(info.getTypeClass());
            type.setTypeMapping(this.getTypeMapping());
            return type;
        }
        return this.nextCreator.createDefaultType(info);
    }

    @Override
    public TypeClassInfo createClassInfo(Method m, int index) {
        Element mapping = this.findMapping(m.getDeclaringClass());
        if (mapping == null) {
            return this.nextCreator.createClassInfo(m, index);
        }
        TypeClassInfo info = this.nextCreator.createClassInfo(m, index);
        if (info == null) {
            info = new TypeClassInfo();
        }
        info.setDescription("method " + m.getName() + " parameter " + index);
        if (index >= 0) {
            if (index >= m.getParameterTypes().length) {
                throw new DatabindingException("Method " + m + " does not have a parameter at index " + index);
            }
            List<Element> nodes = this.getMatches(mapping, "./method[@name='" + m.getName() + "']/parameter[@index='" + index + "']/parent::*");
            if (nodes.size() == 0) {
                return info;
            }
            Element bestMatch = this.getBestMatch(mapping, m, nodes);
            if (bestMatch == null) {
                return info;
            }
            info.setTypeClass(m.getParameterTypes()[index]);
            Element parameter = this.getMatch(bestMatch, "parameter[@index='" + index + "']");
            this.readMetadata(info, mapping, parameter);
        } else {
            List<Element> nodes = this.getMatches(mapping, "./method[@name='" + m.getName() + "']/return-type/parent::*");
            if (nodes.size() == 0) {
                return info;
            }
            Element bestMatch = this.getBestMatch(mapping, m, nodes);
            if (bestMatch == null) {
                return info;
            }
            info.setTypeClass(m.getReturnType());
            Element rtElement = DOMUtils.getFirstChildWithName((Element)bestMatch, (String)"", (String)"return-type");
            this.readMetadata(info, mapping, rtElement);
        }
        return info;
    }

    protected void readMetadata(TypeClassInfo info, Element mapping, Element parameter) {
        String nillable;
        String flat;
        String max;
        info.setTypeName(this.createQName(parameter, DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"typeName")));
        info.setMappedName(this.createQName(parameter, DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"mappedName")));
        this.setComponentType(info, mapping, parameter);
        this.setKeyType(info, mapping, parameter);
        this.setValueType(info, mapping, parameter);
        this.setType(info, parameter);
        String min = DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"minOccurs");
        if (min != null) {
            info.setMinOccurs(Long.parseLong(min));
        }
        if ((max = DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"maxOccurs")) != null) {
            info.setMaxOccurs(Long.parseLong(max));
        }
        if ((flat = DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"flat")) != null) {
            info.setFlat(Boolean.valueOf(flat.toLowerCase()));
        }
        if ((nillable = DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"nillable")) != null) {
            info.setNillable((boolean)Boolean.valueOf(nillable.toLowerCase()));
        }
    }

    @Override
    protected Type getOrCreateGenericType(TypeClassInfo info) {
        Type type = null;
        if (info.getGenericType() != null) {
            type = this.createTypeFromGeneric(info.getGenericType());
        }
        if (type == null) {
            type = super.getOrCreateGenericType(info);
        }
        return type;
    }

    private Type createTypeFromGeneric(Object cType) {
        if (cType instanceof TypeClassInfo) {
            return this.createTypeForClass((TypeClassInfo)cType);
        }
        if (cType instanceof Class) {
            return this.createType((Class)cType);
        }
        return null;
    }

    @Override
    protected Type getOrCreateMapKeyType(TypeClassInfo info) {
        Type type = null;
        if (info.getKeyType() != null) {
            type = this.createTypeFromGeneric(info.getKeyType());
        }
        if (type == null) {
            type = super.getOrCreateMapKeyType(info);
        }
        return type;
    }

    @Override
    protected Type getOrCreateMapValueType(TypeClassInfo info) {
        Type type = null;
        if (info.getGenericType() != null) {
            type = this.createTypeFromGeneric(info.getValueType());
        }
        if (type == null) {
            type = super.getOrCreateMapValueType(info);
        }
        return type;
    }

    protected void setComponentType(TypeClassInfo info, Element mapping, Element parameter) {
        String componentType = DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"componentType");
        if (componentType != null) {
            info.setGenericType(this.loadGeneric(info, mapping, componentType));
        }
    }

    private Object loadGeneric(TypeClassInfo info, Element mapping, String componentType) {
        if (componentType.startsWith("#")) {
            String name = componentType.substring(1);
            Element propertyEl = this.getMatch(mapping, "./component[@name='" + name + "']");
            if (propertyEl == null) {
                throw new DatabindingException("Could not find <component> element in mapping named '" + name + "'");
            }
            TypeClassInfo componentInfo = new TypeClassInfo();
            componentInfo.setDescription("generic component " + componentInfo.getDescription());
            this.readMetadata(componentInfo, mapping, propertyEl);
            String className = DOMUtils.getAttributeValueEmptyNull((Element)propertyEl, (String)"class");
            if (className == null) {
                throw new DatabindingException("A 'class' attribute must be specified for <component> " + name);
            }
            componentInfo.setTypeClass(this.loadComponentClass(className));
            return componentInfo;
        }
        return this.loadComponentClass(componentType);
    }

    private Class loadComponentClass(String componentType) {
        try {
            return ClassLoaderUtils.loadClass((String)componentType, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new DatabindingException("Unable to load component type class " + componentType, (Throwable)e);
        }
    }

    protected void setType(TypeClassInfo info, Element parameter) {
        String type = DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"type");
        if (type != null) {
            try {
                info.setType(ClassLoaderUtils.loadClass((String)type, this.getClass()));
            }
            catch (ClassNotFoundException e) {
                throw new DatabindingException("Unable to load type class " + type, (Throwable)e);
            }
        }
    }

    protected void setKeyType(TypeClassInfo info, Element mapping, Element parameter) {
        String componentType = DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"keyType");
        if (componentType != null) {
            info.setKeyType(this.loadGeneric(info, mapping, componentType));
        }
    }

    private void setValueType(TypeClassInfo info, Element mapping, Element parameter) {
        String componentType = DOMUtils.getAttributeValueEmptyNull((Element)parameter, (String)"valueType");
        if (componentType != null) {
            info.setValueType(this.loadGeneric(info, mapping, componentType));
        }
    }

    private Element getBestMatch(Element mapping, Method method, List<Element> availableNodes) {
        List<Element> nodes = this.getMatches(mapping, "./method[@name='" + method.getName() + "']");
        if (availableNodes != null) {
            nodes.retainAll(availableNodes);
        }
        if (nodes.size() == 0) {
            return null;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            return nodes.get(0);
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> parameterType = parameterTypes[i];
            Iterator<Element> iterator = nodes.iterator();
            while (iterator.hasNext()) {
                Element element = iterator.next();
                Element match = this.getMatch(element, "parameter[@index='" + i + "']");
                if (match == null || DOMUtils.getAttributeValueEmptyNull((Element)match, (String)"class") == null || DOMUtils.getAttributeValueEmptyNull((Element)match, (String)"class").equals(parameterType.getName())) continue;
                iterator.remove();
            }
        }
        if (nodes.size() == 1) {
            return nodes.get(0);
        }
        Element bestCandidate = null;
        int highestSpecified = 0;
        for (Element element : nodes) {
            List params = DOMUtils.getChildrenWithName((Element)element, (String)"", (String)"parameter");
            int availableParameters = params.size();
            if (availableParameters <= highestSpecified) continue;
            bestCandidate = element;
            highestSpecified = availableParameters;
        }
        return bestCandidate;
    }

    private Element getMatch(Node doc, String xpath) {
        return (Element)this.xpathUtils.getValue(xpath, doc, XPathConstants.NODE);
    }

    private List<Element> getMatches(Node doc, String xpath) {
        NodeList nl = (NodeList)this.xpathUtils.getValue(xpath, doc, XPathConstants.NODESET);
        ArrayList<Element> r = new ArrayList<Element>();
        for (int x = 0; x < nl.getLength(); ++x) {
            r.add((Element)nl.item(x));
        }
        return r;
    }

    protected QName createQName(Element e, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(this.getTypeMapping().getMappingIdentifierURI(), value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = DOMUtils.getNamespace((Node)e, (String)prefix);
        if (ns == null || localName == null) {
            throw new DatabindingException("Invalid QName in mapping: " + value);
        }
        return new QName(ns, localName, prefix);
    }

    static {
        stopClasses.add(Object.class);
        stopClasses.add(Exception.class);
        stopClasses.add(RuntimeException.class);
        stopClasses.add(Throwable.class);
        String path = "/META-INF/cxf/aegis.xsd";
        InputStream is = XMLTypeCreator.class.getResourceAsStream(path);
        if (is != null) {
            try {
                aegisDocumentBuilderFactory = DocumentBuilderFactory.newInstance();
                aegisDocumentBuilderFactory.setNamespaceAware(true);
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                aegisSchema = schemaFactory.newSchema(new StreamSource(is));
                is.close();
                aegisDocumentBuilderFactory.setSchema(aegisSchema);
            }
            catch (UnsupportedOperationException e) {
                LOG.log(Level.INFO, "Parser doesn't support setSchema.  Not validating.", e);
            }
            catch (IOException ie) {
                LOG.log(Level.SEVERE, "Error reading Aegis schema", ie);
            }
            catch (FactoryConfigurationError e) {
                LOG.log(Level.SEVERE, "Error reading Aegis schema", e);
            }
            catch (SAXException e) {
                LOG.log(Level.SEVERE, "Error reading Aegis schema", e);
            }
        }
    }
}

