/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.java5;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeClassInfo;
import org.apache.cxf.aegis.type.TypeUtil;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.java5.AnnotatedTypeInfo;
import org.apache.cxf.aegis.type.java5.AnnotationReader;
import org.apache.cxf.aegis.type.java5.EnumType;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.aegis.util.ServiceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java5TypeCreator
extends AbstractTypeCreator {
    private AnnotationReader annotationReader;

    public Java5TypeCreator() {
        this(new AnnotationReader());
    }

    public Java5TypeCreator(AnnotationReader annotationReader) {
        this.annotationReader = annotationReader;
    }

    public static Class<? extends AegisType> castToAegisTypeClass(Class<?> c) {
        if (c == null) {
            return null;
        }
        if (AegisType.class.isAssignableFrom(c)) {
            return c.asSubclass(AegisType.class);
        }
        throw new DatabindingException("Invalid Aegis type annotation to non-type class" + c);
    }

    @Override
    public TypeClassInfo createClassInfo(Method m, int index) {
        TypeClassInfo info;
        if (index >= 0) {
            TypeClassInfo info2;
            Type genericType = m.getGenericParameterTypes()[index];
            if (genericType instanceof Class) {
                info2 = this.nextCreator.createClassInfo(m, index);
            } else {
                info2 = new TypeClassInfo();
                info2.setDescription("method " + m.getName() + " parameter " + index);
                info2.setType(genericType);
            }
            Class paramTypeClass = this.annotationReader.getParamType(m, index);
            info2.setAegisTypeClass(Java5TypeCreator.castToAegisTypeClass(paramTypeClass));
            String paramName = this.annotationReader.getParamName(m, index);
            if (paramName != null) {
                info2.setTypeName(this.createQName(m.getParameterTypes()[index], paramName, this.annotationReader.getParamNamespace(m, index)));
            }
            return info2;
        }
        Type genericReturnType = m.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            info = this.nextCreator.createClassInfo(m, index);
        } else {
            info = new TypeClassInfo();
            info.setDescription("method " + m.getName() + " parameter " + index);
            info.setType(genericReturnType);
        }
        if (m.getParameterAnnotations() != null && m.getAnnotations().length > 0) {
            info.setAnnotations(m.getAnnotations());
        }
        info.setAegisTypeClass(Java5TypeCreator.castToAegisTypeClass(this.annotationReader.getReturnType(m)));
        String returnName = this.annotationReader.getReturnName(m);
        if (returnName != null) {
            info.setTypeName(this.createQName(m.getReturnType(), returnName, this.annotationReader.getReturnNamespace(m)));
        }
        return info;
    }

    @Override
    public TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        Type genericType = pd.getReadMethod().getGenericReturnType();
        TypeClassInfo info = this.createBasicClassInfo(pd.getPropertyType());
        info.setType(genericType);
        info.setAnnotations(pd.getReadMethod().getAnnotations());
        info.setAegisTypeClass(Java5TypeCreator.castToAegisTypeClass(this.annotationReader.getType(pd.getReadMethod())));
        info.setFlat(this.annotationReader.isFlat(pd.getReadMethod().getAnnotations()));
        return info;
    }

    @Override
    public AegisType createCollectionType(TypeClassInfo info) {
        Type type = info.getType();
        Type componentType = this.getComponentType(type, 0);
        if (componentType != null) {
            return this.createCollectionTypeFromGeneric(info);
        }
        return this.nextCreator.createCollectionType(info);
    }

    @Override
    protected AegisType getOrCreateGenericType(TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getType(), 0);
    }

    @Override
    protected AegisType getOrCreateMapKeyType(TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getType(), 0);
    }

    @Override
    protected AegisType getOrCreateMapValueType(TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getType(), 1);
    }

    protected AegisType getOrCreateParameterizedType(Type generic, int index) {
        Type paramType = this.getComponentType(generic, index);
        if (paramType == null) {
            return this.createObjectType();
        }
        Class<?> clazz = TypeUtil.getTypeRelatedClass(paramType);
        if (clazz == null) {
            return this.createObjectType();
        }
        if (!Collection.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz)) {
            return this.getTopCreator().createType(clazz);
        }
        TypeClassInfo info = this.createBasicClassInfo(clazz);
        info.setDescription(clazz.toString());
        info.setType(paramType);
        AegisType type = this.createTypeForClass(info);
        return type;
    }

    protected Type getComponentType(Type genericType, int index) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            Type paramType = type.getActualTypeArguments()[index];
            if (paramType instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)paramType;
                return wildcardType.getUpperBounds()[0];
            }
            return paramType;
        }
        return null;
    }

    @Override
    public AegisType createDefaultType(TypeClassInfo info) {
        QName typeName = info.getTypeName();
        Class<?> relatedClass = TypeUtil.getTypeRelatedClass(info.getType());
        if (typeName == null) {
            typeName = this.createQName(relatedClass);
        }
        AnnotatedTypeInfo typeInfo = new AnnotatedTypeInfo(this.getTypeMapping(), relatedClass, typeName.getNamespaceURI(), this.getConfiguration());
        typeInfo.setExtensibleElements(this.annotationReader.isExtensibleElements(relatedClass, this.getConfiguration().isDefaultExtensibleElements()));
        typeInfo.setExtensibleAttributes(this.annotationReader.isExtensibleAttributes(relatedClass, this.getConfiguration().isDefaultExtensibleAttributes()));
        typeInfo.setDefaultMinOccurs(this.getConfiguration().getDefaultMinOccurs());
        typeInfo.setDefaultNillable(this.getConfiguration().isDefaultNillable());
        BeanType type = new BeanType(typeInfo);
        type.setTypeMapping(this.getTypeMapping());
        type.setSchemaType(typeName);
        return type;
    }

    @Override
    public AegisType createEnumType(TypeClassInfo info) {
        EnumType type = new EnumType();
        type.setSchemaType(this.createQName(TypeUtil.getTypeRelatedClass(info.getType())));
        type.setTypeClass(info.getType());
        type.setTypeMapping(this.getTypeMapping());
        return type;
    }

    @Override
    public QName createQName(Class typeClass) {
        String name = this.annotationReader.getName(typeClass);
        String ns = this.annotationReader.getNamespace(typeClass);
        return this.createQName(typeClass, name, ns);
    }

    private QName createQName(Class typeClass, String name, String ns) {
        if (name == null || name.length() == 0) {
            name = ServiceUtils.makeServiceNameFromClassName(typeClass);
        }
        if (ns == null || ns.length() == 0) {
            ns = this.annotationReader.getNamespace(typeClass);
        }
        if (ns == null || ns.length() == 0) {
            ns = this.annotationReader.getNamespace(typeClass.getPackage());
        }
        if (ns == null || ns.length() == 0) {
            ns = NamespaceHelper.makeNamespaceFromClassName(typeClass.getName(), "http");
        }
        return new QName(ns, name);
    }

    @Override
    protected boolean isEnum(Class javaType) {
        return javaType.isEnum();
    }
}

