/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.mtom.AbstractXOPType;
import org.apache.cxf.aegis.type.mtom.ByteArrayType;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64Utility;

public class Base64Type
extends AegisType {
    private AbstractXOPType optimizedType;

    public Base64Type() {
        this.optimizedType = new ByteArrayType(false, null);
    }

    public Base64Type(AbstractXOPType xopType) {
        this.optimizedType = xopType;
    }

    public Object readObject(MessageReader mreader, Context context) throws DatabindingException {
        XMLStreamReader reader = mreader.getXMLStreamReader();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            reader.next();
            while (!(reader.isCharacters() || reader.isEndElement() || reader.isStartElement())) {
                reader.next();
            }
            if (reader.isStartElement() && reader.getName().equals(AbstractXOPType.XOP_INCLUDE)) {
                return this.optimizedType.readMtoM(mreader, context);
            }
            if (reader.isEndElement()) {
                reader.next();
                return new byte[0];
            }
            CharArrayWriter writer = new CharArrayWriter(2048);
            while (reader.isCharacters()) {
                writer.write(reader.getTextCharacters(), reader.getTextStart(), reader.getTextLength());
                reader.next();
            }
            Base64Utility.decode((char[])writer.toCharArray(), (int)0, (int)writer.size(), (OutputStream)bos);
            while (reader.getEventType() != 2) {
                reader.next();
            }
            reader.next();
            return bos.toByteArray();
        }
        catch (Base64Exception e) {
            throw new DatabindingException("Could not parse base64Binary data.", (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new DatabindingException("Could not parse base64Binary data.", (Throwable)e);
        }
    }

    public void writeObject(Object object, MessageWriter writer, Context context) throws DatabindingException {
        boolean mtomEnabled = context.isMtomEnabled();
        if (mtomEnabled) {
            this.optimizedType.writeObject(object, writer, context);
            return;
        }
        byte[] data = (byte[])object;
        if (data != null && data.length > 0) {
            writer.writeValue(Base64Utility.encode((byte[])data));
        }
    }
}

