/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import com.sun.xml.bind.v2.ContextFactory;
import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.i18n.UncheckedException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.DataReader;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.jaxb.io.DataReaderImpl;
import org.apache.cxf.jaxb.io.DataWriterImpl;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.wsdl11.WSDLServiceBuilder;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBDataBinding
implements DataBinding {
    public static final String SCHEMA_RESOURCE = "SCHEMRESOURCE";
    public static final String UNWRAP_JAXB_ELEMENT = "unwrap.jaxb.element";
    private static final Logger LOG = Logger.getLogger(JAXBDataBinding.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXBDataBinding.class);
    private static final Class<?>[] SUPPORTED_READER_FORMATS = new Class[]{Node.class, XMLEventReader.class, XMLStreamReader.class};
    private static final Class<?>[] SUPPORTED_WRITER_FORMATS = new Class[]{OutputStream.class, Node.class, XMLEventWriter.class, XMLStreamWriter.class};
    Class[] extraClass;
    JAXBContext context;
    Class cls;

    public JAXBDataBinding() {
    }

    public JAXBDataBinding(Class<?> ... classes) throws JAXBException {
        HashSet classSet = new HashSet();
        classSet.addAll(Arrays.asList(classes));
        this.setContext(this.createJAXBContext(classSet));
    }

    public JAXBDataBinding(JAXBContext context) {
        this();
        this.setContext(context);
    }

    public JAXBContext getContext() {
        return this.context;
    }

    public void setContext(JAXBContext ctx) {
        this.context = ctx;
    }

    public <T> DataWriter<T> createWriter(Class<T> c) {
        if (c == XMLStreamWriter.class) {
            return new DataWriterImpl(this.context);
        }
        if (c == OutputStream.class) {
            return new DataWriterImpl(this.context);
        }
        if (c == XMLEventWriter.class) {
            return new DataWriterImpl(this.context);
        }
        if (c == Node.class) {
            return new DataWriterImpl(this.context);
        }
        return null;
    }

    public Class<?>[] getSupportedWriterFormats() {
        return SUPPORTED_WRITER_FORMATS;
    }

    public <T> DataReader<T> createReader(Class<T> c) {
        DataReaderImpl dr = null;
        if (c == XMLStreamReader.class) {
            dr = new DataReaderImpl(this.context);
        } else if (c == XMLEventReader.class) {
            dr = new DataReaderImpl(this.context);
        } else if (c == Node.class) {
            dr = new DataReaderImpl(this.context);
        }
        return dr;
    }

    public Class<?>[] getSupportedReaderFormats() {
        return SUPPORTED_READER_FORMATS;
    }

    public Map<String, SchemaInfo> getSchemas(ServiceInfo serviceInfo) {
        List schemaResources = CastUtils.cast((List)((List)serviceInfo.getProperty(SCHEMA_RESOURCE, List.class)), String.class);
        return this.loadSchemas(schemaResources);
    }

    private Map<String, SchemaInfo> loadSchemas(Collection<String> schemaResources) {
        HashMap<String, SchemaInfo> schemas = new HashMap<String, SchemaInfo>();
        for (String schema : schemaResources) {
            URIResolver resolver = null;
            try {
                resolver = new URIResolver(schema);
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage());
            }
            if (!resolver.isResolved()) {
                throw new UncheckedException(new Message("SCHEMA_NOT_RESOLVED", BUNDLE, new Object[]{schema}));
            }
            if (resolver.isFile()) {
                this.loadSchemaFromFile(schema, schemas);
                continue;
            }
            this.loadSchemaFromClassPath(schema, schemas);
        }
        return schemas;
    }

    private void loadSchemaFromClassPath(String schema, Map<String, SchemaInfo> schemas) {
        try {
            XmlSchemaCollection schemaCol = new XmlSchemaCollection();
            URIResolver resolver = new URIResolver(schema);
            Document schemaDoc = DOMUtils.readXml((InputStream)resolver.getInputStream());
            XmlSchema xmlSchema = schemaCol.read(schemaDoc.getDocumentElement());
            SchemaInfo schemaInfo = new SchemaInfo(null, xmlSchema.getTargetNamespace());
            schemaInfo.setElement(schemaDoc.getDocumentElement());
            schemas.put(schemaInfo.getNamespaceURI(), schemaInfo);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
        catch (SAXException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
    }

    private void loadSchemaFromFile(String schema, Map<String, SchemaInfo> schemas) {
        try {
            XmlSchemaCollection schemaCol = new XmlSchemaCollection();
            URIResolver resolver = new URIResolver(schema);
            schemaCol.setBaseUri(resolver.getFile().getParent());
            Document schemaDoc = DOMUtils.readXml((InputStream)resolver.getInputStream());
            XmlSchema xmlSchema = schemaCol.read(schemaDoc.getDocumentElement());
            SchemaInfo schemaInfo = new SchemaInfo(null, xmlSchema.getTargetNamespace());
            schemaInfo.setElement(schemaDoc.getDocumentElement());
            schemas.put(schemaInfo.getNamespaceURI(), schemaInfo);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
        catch (SAXException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            LOG.log(Level.SEVERE, e.getMessage());
            throw new UncheckedException((Throwable)e);
        }
    }

    private boolean isSameTNS(ServiceInfo service) {
        return service.getName().getNamespaceURI().equals(service.getInterface().getName().getNamespaceURI());
    }

    public void initialize(Service service) {
        if (this.context != null) {
            return;
        }
        HashSet classes = new HashSet();
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            JAXBContextInitializer initializer = new JAXBContextInitializer(serviceInfo, classes);
            initializer.walk();
        }
        try {
            String tns = service.getName().getNamespaceURI();
            if (service.getServiceInfos().size() > 0) {
                tns = ((ServiceInfo)service.getServiceInfos().get(0)).getInterface().getName().getNamespaceURI();
            }
            this.setContext(this.createJAXBContext(classes, tns));
        }
        catch (JAXBException e1) {
            throw new ServiceConstructionException((Throwable)e1);
        }
        for (ServiceInfo serviceInfo : service.getServiceInfos()) {
            JAXBContextImpl riContext;
            XmlSchemaCollection col = (XmlSchemaCollection)serviceInfo.getProperty(WSDLServiceBuilder.WSDL_SCHEMA_LIST);
            if (col != null) continue;
            col = new XmlSchemaCollection();
            try {
                for (DOMResult r : this.generateJaxbSchemas()) {
                    Document d = (Document)r.getNode();
                    String ns = d.getDocumentElement().getAttribute("targetNamespace");
                    if (StringUtils.isEmpty((String)ns) || !this.isSameTNS(serviceInfo)) {
                        ns = serviceInfo.getInterface().getName().getNamespaceURI();
                        d.getDocumentElement().setAttribute("targetNamespace", ns);
                    }
                    NodeList nodes = d.getDocumentElement().getChildNodes();
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Element e;
                        Node n = nodes.item(i);
                        if (!(n instanceof Element) || !(e = (Element)n).getLocalName().equals("import")) continue;
                        d.getDocumentElement().removeChild(e);
                    }
                    SchemaInfo schema = new SchemaInfo(serviceInfo, ns);
                    schema.setElement(d.getDocumentElement());
                    schema.setSystemId(r.getSystemId());
                    XmlSchema xmlSchema = col.read(d.getDocumentElement());
                    schema.setSchema(xmlSchema);
                    serviceInfo.addSchema(schema);
                }
            }
            catch (IOException e) {
                throw new ServiceConstructionException(new Message("SCHEMA_GEN_EXC", BUNDLE, new Object[0]), (Throwable)e);
            }
            serviceInfo.setProperty(WSDLServiceBuilder.WSDL_SCHEMA_LIST, (Object)col);
            if (this.context instanceof JAXBContextImpl) {
                riContext = (JAXBContextImpl)this.context;
            } else {
                try {
                    riContext = (JAXBContextImpl)ContextFactory.createContext((Class[])classes.toArray(new Class[classes.size()]), null);
                }
                catch (JAXBException e) {
                    throw new ServiceConstructionException((Throwable)e);
                }
            }
            JAXBSchemaInitializer schemaInit = new JAXBSchemaInitializer(serviceInfo, col, riContext);
            schemaInit.walk();
        }
    }

    public void setExtraClass(Class[] userExtraClass) {
        this.extraClass = userExtraClass;
    }

    public Class[] getExtraClass() {
        return this.extraClass;
    }

    private List<DOMResult> generateJaxbSchemas() throws IOException {
        final ArrayList<DOMResult> results = new ArrayList<DOMResult>();
        this.context.generateSchema(new SchemaOutputResolver(){

            public Result createOutput(String ns, String file) throws IOException {
                DOMResult result = new DOMResult();
                result.setSystemId(file);
                if ("http://www.w3.org/2005/02/addressing/wsdl".equals(ns)) {
                    return result;
                }
                results.add(result);
                return result;
            }
        });
        return results;
    }

    public JAXBContext createJAXBContext(Set<Class<?>> classes) throws JAXBException {
        return this.createJAXBContext(classes, null);
    }

    public JAXBContext createJAXBContext(Set<Class<?>> classes, String defaultNs) throws JAXBException {
        Iterator<Class<?>> it = classes.iterator();
        String className = "";
        Class<?> remoteExceptionObject = null;
        while (it.hasNext()) {
            remoteExceptionObject = it.next();
            className = ((Object)remoteExceptionObject).toString();
            if ("".equals(className) || !className.contains("RemoteException")) continue;
            classes.remove(remoteExceptionObject);
        }
        for (Class<?> clz : classes) {
            if (!clz.getName().endsWith("ObjectFactory")) continue;
            defaultNs = null;
        }
        try {
            classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.AttributedQNameType"));
            classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ObjectFactory"));
            classes.add(Class.forName("org.apache.cxf.ws.addressing.wsdl.ServiceNameType"));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (this.extraClass != null && this.extraClass.length > 0) {
                for (Class clz : this.extraClass) {
                    classes.add(clz);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (defaultNs != null) {
            map.put("com.sun.xml.bind.defaultNamespaceRemap", defaultNs);
        }
        return JAXBContext.newInstance((Class[])classes.toArray(new Class[classes.size()]), map);
    }
}

