/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.service.factory;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.util.factory.Factory;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.frontend.MethodDispatcher;
import org.apache.cxf.frontend.SimpleMethodDispatcher;
import org.apache.cxf.helpers.MethodComparator;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.ServiceImpl;
import org.apache.cxf.service.factory.AbstractServiceConfiguration;
import org.apache.cxf.service.factory.AbstractServiceFactoryBean;
import org.apache.cxf.service.factory.DefaultServiceConfiguration;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.ApplicationScopePolicy;
import org.apache.cxf.service.invoker.FactoryInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.service.invoker.LocalFactory;
import org.apache.cxf.service.invoker.ScopePolicy;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotated;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSerializer;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.commons.schema.utils.NamespacePrefixList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectionServiceFactoryBean
extends AbstractServiceFactoryBean {
    public static final String GENERIC_TYPE = "generic.type";
    public static final String MODE_OUT = "messagepart.mode.out";
    public static final String MODE_INOUT = "messagepart.mode.inout";
    public static final String HOLDER = "messagepart.isholder";
    private static final Logger LOG = Logger.getLogger(ReflectionServiceFactoryBean.class.getName());
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(ReflectionServiceFactoryBean.class);
    protected URL wsdlURL;
    protected Class<?> serviceClass;
    private List<AbstractServiceConfiguration> serviceConfigurations = new ArrayList<AbstractServiceConfiguration>();
    private QName serviceName;
    private Invoker invoker;
    private Executor executor;
    private List<String> ignoredClasses = new ArrayList<String>();
    private SimpleMethodDispatcher methodDispatcher = new SimpleMethodDispatcher();
    private Boolean wrappedStyle;
    private Map<String, Object> properties;

    public ReflectionServiceFactoryBean() {
        this.getServiceConfigurations().add(0, new DefaultServiceConfiguration());
        this.setDataBinding((DataBinding)new JAXBDataBinding());
        this.ignoredClasses.add("java.lang.Object");
        this.ignoredClasses.add("java.lang.Throwable");
        this.ignoredClasses.add("org.omg.CORBA_2_3.portable.ObjectImpl");
        this.ignoredClasses.add("org.omg.CORBA.portable.ObjectImpl");
        this.ignoredClasses.add("javax.ejb.EJBObject");
        this.ignoredClasses.add("javax.rmi.CORBA.Stub");
    }

    public Service create() {
        this.initializeServiceConfigurations();
        this.initializeServiceModel();
        this.initializeDataBindings();
        this.initializeDefaultInterceptors();
        if (this.invoker != null) {
            this.getService().setInvoker(this.getInvoker());
        } else {
            this.getService().setInvoker(this.createInvoker());
        }
        if (this.getExecutor() != null) {
            this.getService().setExecutor(this.getExecutor());
        } else {
            this.getService().setExecutor((Executor)SynchronousExecutor.getInstance());
        }
        this.getService().put((Object)MethodDispatcher.class.getName(), (Object)this.getMethodDispatcher());
        this.createEndpoints();
        return this.getService();
    }

    protected void createEndpoints() {
        Service service = this.getService();
        for (EndpointInfo ei : service.getServiceInfo().getEndpoints()) {
            try {
                Endpoint ep = this.createEndpoint(ei);
                service.getEndpoints().put(ei.getName(), ep);
            }
            catch (EndpointException e) {
                throw new ServiceConstructionException((Throwable)e);
            }
        }
    }

    public Endpoint createEndpoint(EndpointInfo ei) throws EndpointException {
        return new EndpointImpl(this.getBus(), this.getService(), ei);
    }

    protected void initializeServiceConfigurations() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            c.setServiceFactory(this);
        }
    }

    protected void buildServiceFromWSDL(URL url) {
        LOG.info("Creating Service " + this.getServiceQName() + " from WSDL.");
        WSDLServiceFactory factory = new WSDLServiceFactory(this.getBus(), url, this.getServiceQName());
        this.setService(factory.create());
        this.initializeWSDLOperations();
        if (this.getDataBinding() != null) {
            this.getDataBinding().initialize(this.getService().getServiceInfo());
        }
    }

    protected void buildServiceFromClass() {
        LOG.info("Creating Service " + this.getServiceQName() + " from class " + this.getServiceClass().getName());
        ServiceInfo serviceInfo = new ServiceInfo();
        ServiceImpl service = new ServiceImpl(serviceInfo);
        serviceInfo.setName(this.getServiceQName());
        serviceInfo.setTargetNamespace(serviceInfo.getName().getNamespaceURI());
        this.createInterface(serviceInfo);
        if (this.isWrapped()) {
            this.initializeWrappedElementNames(serviceInfo);
        }
        if (this.getDataBinding() != null) {
            this.getDataBinding().initialize(serviceInfo);
        }
        if (this.isWrapped()) {
            this.initializeWrappedSchema(serviceInfo);
        }
        this.setService((Service)service);
    }

    protected void initializeServiceModel() {
        URL url = this.getWsdlURL();
        if (url != null) {
            this.buildServiceFromWSDL(url);
        } else {
            this.buildServiceFromClass();
        }
        if (this.properties != null) {
            this.getService().putAll(this.properties);
        }
    }

    protected void initializeWSDLOperations() {
        Method[] methods = this.serviceClass.getMethods();
        Arrays.sort(methods, new MethodComparator());
        InterfaceInfo intf = this.getService().getServiceInfo().getInterface();
        for (OperationInfo o : intf.getOperations()) {
            Method selected = null;
            for (Method m : methods) {
                if (!this.isValidMethod(m)) continue;
                QName opName = this.getOperationName(intf, m);
                if (!o.getName().getNamespaceURI().equals(opName.getNamespaceURI()) || !this.isMatchOperation(o.getName().getLocalPart(), opName.getLocalPart())) continue;
                selected = m;
                break;
            }
            if (selected == null) {
                throw new ServiceConstructionException(new Message("NO_METHOD_FOR_OP", BUNDLE, new Object[]{o.getName()}));
            }
            this.initializeWSDLOperation(intf, o, selected);
        }
    }

    protected void initializeWSDLOperation(InterfaceInfo intf, OperationInfo o, Method selected) {
    }

    protected Invoker createInvoker() {
        return new FactoryInvoker((Factory)new LocalFactory(this.getServiceClass()), (ScopePolicy)new ApplicationScopePolicy());
    }

    protected ServiceInfo createServiceInfo(InterfaceInfo intf) {
        ServiceInfo svcInfo = new ServiceInfo();
        svcInfo.setInterface(intf);
        return svcInfo;
    }

    protected InterfaceInfo createInterface(ServiceInfo serviceInfo) {
        QName intfName = this.getInterfaceName();
        InterfaceInfo intf = new InterfaceInfo(serviceInfo, intfName);
        Method[] methods = this.serviceClass.getMethods();
        Arrays.sort(methods, new MethodComparator());
        for (Method m : this.serviceClass.getMethods()) {
            if (!this.isValidMethod(m)) continue;
            this.createOperation(serviceInfo, intf, m);
        }
        return intf;
    }

    protected OperationInfo createOperation(ServiceInfo serviceInfo, InterfaceInfo intf, Method m) {
        OperationInfo op = intf.addOperation(this.getOperationName(intf, m));
        if (this.isWrapped(m)) {
            UnwrappedOperationInfo uOp = new UnwrappedOperationInfo(op);
            op.setUnwrappedOperation((OperationInfo)uOp);
            this.createMessageParts(intf, (OperationInfo)uOp, m);
            if (uOp.hasInput()) {
                MessageInfo msg = new MessageInfo(op, op.getName());
                op.setInput(uOp.getInputName(), msg);
                msg.addMessagePart(op.getName());
            }
            if (uOp.hasOutput()) {
                QName name = new QName(op.getName().getNamespaceURI(), op.getName().getLocalPart() + "Response");
                MessageInfo msg = new MessageInfo(op, name);
                op.setOutput(uOp.getOutputName(), msg);
                MessagePartInfo part = msg.addMessagePart(name);
                part.setIndex(-1);
            }
        } else {
            this.createMessageParts(intf, op, m);
        }
        this.methodDispatcher.bind(op, m);
        return op;
    }

    private void initializeWrappedElementNames(ServiceInfo serviceInfo) {
        for (OperationInfo op : serviceInfo.getInterface().getOperations()) {
            if (op.hasInput()) {
                this.setElementNameOnPart(op.getInput());
            }
            if (!op.hasOutput()) continue;
            this.setElementNameOnPart(op.getOutput());
        }
    }

    private void setElementNameOnPart(MessageInfo m) {
        List parts = m.getMessageParts();
        if (parts.size() == 1) {
            MessagePartInfo p = (MessagePartInfo)parts.get(0);
            p.setElement(true);
            p.setElementQName(m.getName());
        }
    }

    protected void initializeWrappedSchema(ServiceInfo serviceInfo) {
        Document[] docs;
        XmlSchemaCollection col = new XmlSchemaCollection();
        XmlSchema schema = new XmlSchema(this.getServiceNamespace(), col);
        schema.setElementFormDefault(new XmlSchemaForm("qualified"));
        serviceInfo.setXmlSchemaCollection(col);
        NamespaceMap nsMap = new NamespaceMap();
        nsMap.add("xsd", "http://www.w3.org/2001/XMLSchema");
        schema.setNamespaceContext((NamespacePrefixList)nsMap);
        for (OperationInfo op : serviceInfo.getInterface().getOperations()) {
            if (op.hasInput()) {
                this.createWrappedMessage(op.getInput(), op.getUnwrappedOperation().getInput(), schema);
            }
            if (!op.hasOutput()) continue;
            this.createWrappedMessage(op.getOutput(), op.getUnwrappedOperation().getOutput(), schema);
        }
        try {
            docs = XmlSchemaSerializer.serializeSchema((XmlSchema)schema, (boolean)false);
        }
        catch (XmlSchemaSerializer.XmlSchemaSerializerException e1) {
            throw new ServiceConstructionException((Throwable)e1);
        }
        Element e = docs[0].getDocumentElement();
        SchemaInfo schemaInfo = new SchemaInfo(serviceInfo, this.getServiceNamespace());
        schemaInfo.setElement(e);
        schemaInfo.setSchema(schema);
        serviceInfo.addSchema(schemaInfo);
    }

    private void createWrappedMessage(MessageInfo wrappedMessage, MessageInfo unwrappedMessage, XmlSchema schema) {
        XmlSchemaElement el = new XmlSchemaElement();
        el.setQName(wrappedMessage.getName());
        el.setName(wrappedMessage.getName().getLocalPart());
        schema.getItems().add((XmlSchemaObject)el);
        ((MessagePartInfo)wrappedMessage.getMessageParts().get(0)).setXmlSchema((XmlSchemaAnnotated)el);
        XmlSchemaComplexType ct = new XmlSchemaComplexType(schema);
        el.setSchemaType((XmlSchemaType)ct);
        XmlSchemaSequence seq = new XmlSchemaSequence();
        ct.setParticle((XmlSchemaParticle)seq);
        for (MessagePartInfo mpi : unwrappedMessage.getMessageParts()) {
            el = new XmlSchemaElement();
            el.setName(mpi.getName().getLocalPart());
            el.setQName(mpi.getName());
            el.setMinOccurs(1L);
            el.setMaxOccurs(1L);
            if (mpi.isElement()) {
                el.setRefName(mpi.getElementQName());
            } else {
                el.setSchemaTypeName(mpi.getTypeQName());
            }
            seq.getItems().add((XmlSchemaObject)el);
        }
    }

    protected void createMessageParts(InterfaceInfo intf, OperationInfo op, Method method) {
        Class<?>[] paramClasses = method.getParameterTypes();
        MessageInfo inMsg = op.createMessage(this.getInputMessageName(op));
        op.setInput(inMsg.getName().getLocalPart(), inMsg);
        for (int j = 0; j < paramClasses.length; ++j) {
            if (!this.isInParam(method, j)) continue;
            QName q = this.getInParameterName(op, method, j);
            MessagePartInfo part = inMsg.addMessagePart(q);
            this.initializeParameter(part, paramClasses[j], method.getGenericParameterTypes()[j]);
            if (this.isHeader(method, j)) {
                part.setElementQName(q);
            }
            part.setIndex(j);
        }
        if (this.hasOutMessage(method)) {
            MessageInfo outMsg = op.createMessage(this.createOutputMessageName(op));
            op.setOutput(outMsg.getName().getLocalPart(), outMsg);
            Class<Void> returnType = method.getReturnType();
            if (!returnType.isAssignableFrom(Void.TYPE)) {
                QName q = this.getOutParameterName(op, method, -1);
                MessagePartInfo part = outMsg.addMessagePart(q);
                this.initializeParameter(part, method.getReturnType(), method.getGenericReturnType());
                part.setIndex(-1);
            }
            for (int j = 0; j < paramClasses.length; ++j) {
                if (!this.isOutParam(method, j)) continue;
                QName q = this.getInParameterName(op, method, j);
                MessagePartInfo part = outMsg.addMessagePart(q);
                this.initializeParameter(part, paramClasses[j], method.getGenericParameterTypes()[j]);
                part.setIndex(j);
                if (this.isInParam(method, j)) {
                    part.setProperty(MODE_INOUT, (Object)Boolean.TRUE);
                }
                if (!this.isHeader(method, j)) continue;
                part.setElementQName(q);
            }
        }
        this.initializeFaults(intf, op, method);
    }

    protected void initializeParameter(MessagePartInfo part, Class rawClass, Type type) {
        if (rawClass.equals(Holder.class) && type instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)type;
            rawClass = this.getHolderClass(paramType);
        }
        part.setProperty(GENERIC_TYPE, (Object)type);
        part.setTypeClass(rawClass);
    }

    protected Class getHolderClass(ParameterizedType paramType) {
        Class<?> rawClass;
        Type rawType = paramType.getActualTypeArguments()[0];
        if (rawType instanceof GenericArrayType) {
            rawClass = (Class<?>)((GenericArrayType)rawType).getGenericComponentType();
            rawClass = Array.newInstance(rawClass, 0).getClass();
        } else {
            if (rawType instanceof ParameterizedType) {
                rawType = (Class)((ParameterizedType)rawType).getRawType();
            }
            rawClass = (Class)rawType;
        }
        return rawClass;
    }

    protected QName getServiceQName() {
        if (this.serviceName == null) {
            this.serviceName = new QName(this.getServiceNamespace(), this.getServiceName());
        }
        return this.serviceName;
    }

    public QName getEndpointName() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName name = c.getEndpointName();
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected String getServiceName() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String name = c.getServiceName();
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected String getServiceNamespace() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String name = c.getServiceNamespace();
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName getInterfaceName() {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName name = c.getInterfaceName();
            if (name == null) continue;
            return name;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected boolean isValidMethod(Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isOperation(method);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected boolean isWrapped(Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isWrapped(method);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected boolean isMatchOperation(String methodNameInClass, String methodNameInWsdl) {
        String initOfMethodInWsdl;
        boolean ret = false;
        String initOfMethodInClass = methodNameInClass.substring(0, 1);
        if (initOfMethodInClass.equalsIgnoreCase(initOfMethodInWsdl = methodNameInWsdl.substring(0, 1)) && methodNameInClass.substring(1, methodNameInClass.length()).equals(methodNameInWsdl.substring(1, methodNameInWsdl.length()))) {
            ret = true;
        }
        return ret;
    }

    protected boolean isOutParam(Method method, int j) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isOutParam(method, j);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected boolean isInParam(Method method, int j) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isInParam(method, j);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected QName getInputMessageName(OperationInfo op) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInputMessageName(op);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName createOutputMessageName(OperationInfo op) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutputMessageName(op);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected boolean hasOutMessage(Method m) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.hasOutMessage(m);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected void initializeFaults(InterfaceInfo service, OperationInfo op, Method method) {
        Class<?>[] exceptionClasses = method.getExceptionTypes();
        for (int i = 0; i < exceptionClasses.length; ++i) {
            Class<?> exClazz = exceptionClasses[i];
            if (exClazz.equals(Exception.class) || Fault.class.isAssignableFrom(exClazz) || exClazz.equals(RuntimeException.class) || exClazz.equals(Throwable.class)) continue;
            this.addFault(service, op, exClazz);
        }
    }

    protected FaultInfo addFault(InterfaceInfo service, OperationInfo op, Class exClass) {
        Class<?> beanClass = this.getBeanClass(exClass);
        QName faultName = this.getFaultName(service, op, exClass, beanClass);
        FaultInfo fi = op.addFault(faultName, faultName);
        fi.setProperty(Class.class.getName(), (Object)exClass);
        MessagePartInfo mpi = fi.addMessagePart(faultName);
        mpi.setTypeClass(beanClass);
        return fi;
    }

    protected Class<?> getBeanClass(Class<?> exClass) {
        return exClass;
    }

    protected QName getFaultName(InterfaceInfo service, OperationInfo o, Class exClass, Class beanClass) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getFaultName(service, o, exClass, beanClass);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected String getAction(OperationInfo op) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            String s = c.getAction(op);
            if (s == null) continue;
            return s;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    public boolean isHeader(Method method, int j) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isHeader(method, j);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected QName getOperationName(InterfaceInfo service, Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName s = c.getOperationName(service, method);
            if (s == null) continue;
            return s;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected boolean isAsync(Method method) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isAsync(method);
            if (b == null) continue;
            return b;
        }
        return true;
    }

    protected QName getInPartName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber == -1) {
            return null;
        }
        if (this.isWrapped(method)) {
            return this.getInParameterName(op, method, paramNumber);
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInPartName(op, method, paramNumber);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName getInParameterName(OperationInfo op, Method method, int paramNumber) {
        if (paramNumber == -1) {
            return null;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getInParameterName(op, method, paramNumber);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName getOutParameterName(OperationInfo op, Method method, int paramNumber) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutParameterName(op, method, paramNumber);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected QName getOutPartName(OperationInfo op, Method method, int paramNumber) {
        if (this.isWrapped(method)) {
            return this.getOutParameterName(op, method, paramNumber);
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            QName q = c.getOutPartName(op, method, paramNumber);
            if (q == null) continue;
            return q;
        }
        throw new IllegalStateException("ServiceConfiguration must provide a value!");
    }

    protected Class getResponseWrapper(Method selected) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Class cls = c.getResponseWrapper(selected);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    protected Class getRequestWrapper(Method selected) {
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Class cls = c.getRequestWrapper(selected);
            if (cls == null) continue;
            return cls;
        }
        return null;
    }

    protected SimpleMethodDispatcher getMethodDispatcher() {
        return this.methodDispatcher;
    }

    public List<AbstractServiceConfiguration> getConfigurations() {
        return this.serviceConfigurations;
    }

    public void setConfigurations(List<AbstractServiceConfiguration> configurations) {
        this.serviceConfigurations = configurations;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public URL getWsdlURL() {
        if (this.wsdlURL == null) {
            for (AbstractServiceConfiguration c : this.serviceConfigurations) {
                this.wsdlURL = c.getWsdlURL();
                if (this.wsdlURL == null) continue;
                break;
            }
        }
        return this.wsdlURL;
    }

    public void setWsdlURL(URL wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    public List<AbstractServiceConfiguration> getServiceConfigurations() {
        return this.serviceConfigurations;
    }

    public void setServiceConfigurations(List<AbstractServiceConfiguration> serviceConfigurations) {
        this.serviceConfigurations = serviceConfigurations;
    }

    public void setServiceName(QName serviceName) {
        this.serviceName = serviceName;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    public List<String> getIgnoredClasses() {
        return this.ignoredClasses;
    }

    public void setIgnoredClasses(List<String> ignoredClasses) {
        this.ignoredClasses = ignoredClasses;
    }

    public boolean isWrapped() {
        if (this.wrappedStyle != null) {
            return this.wrappedStyle;
        }
        for (AbstractServiceConfiguration c : this.serviceConfigurations) {
            Boolean b = c.isWrapped();
            if (b == null) continue;
            return b;
        }
        return true;
    }

    public void setWrapped(boolean style) {
        this.wrappedStyle = style;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }
}

