/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingConfiguration;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.AbstractBasicInterceptorProvider;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientProxyFactoryBean
extends AbstractBasicInterceptorProvider {
    private ClientFactoryBean clientFactoryBean = new ClientFactoryBean();
    private String username;
    private String password;
    private Map<String, Object> properties;
    private Bus bus;
    private List<AbstractFeature> features;
    private DataBinding dataBinding;

    public Object create() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        if (this.username != null) {
            AuthorizationPolicy authPolicy = new AuthorizationPolicy();
            authPolicy.setUserName(this.username);
            authPolicy.setPassword(this.password);
            this.properties.put(AuthorizationPolicy.class.getName(), authPolicy);
        }
        this.clientFactoryBean.setFeatures(this.features);
        this.clientFactoryBean.setProperties(this.properties);
        if (this.bus != null) {
            this.clientFactoryBean.setBus(this.bus);
        }
        if (this.dataBinding != null) {
            this.clientFactoryBean.setDataBinding(this.dataBinding);
        }
        Client c = this.clientFactoryBean.create();
        if (this.getInInterceptors() != null) {
            c.getInInterceptors().addAll(this.getInInterceptors());
        }
        if (this.getOutInterceptors() != null) {
            c.getOutInterceptors().addAll(this.getOutInterceptors());
        }
        if (this.getInFaultInterceptors() != null) {
            c.getInFaultInterceptors().addAll(this.getInFaultInterceptors());
        }
        if (this.getOutFaultInterceptors() != null) {
            c.getOutFaultInterceptors().addAll(this.getOutFaultInterceptors());
        }
        ClientProxy handler = this.clientClientProxy(c);
        Object obj = Proxy.newProxyInstance(this.clientFactoryBean.getServiceClass().getClassLoader(), this.getImplementingClasses(), (InvocationHandler)handler);
        return obj;
    }

    protected Class[] getImplementingClasses() {
        Class cls = this.clientFactoryBean.getServiceClass();
        return new Class[]{cls};
    }

    protected ClientProxy clientClientProxy(Client c) {
        return new ClientProxy(c);
    }

    public ClientFactoryBean getClientFactoryBean() {
        return this.clientFactoryBean;
    }

    public void setClientFactoryBean(ClientFactoryBean clientFactoryBean) {
        this.clientFactoryBean = clientFactoryBean;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Class getServiceClass() {
        return this.clientFactoryBean.getServiceClass();
    }

    public void setServiceClass(Class serviceClass) {
        this.clientFactoryBean.setServiceClass(serviceClass);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getWsdlLocation() {
        return this.getWsdlURL();
    }

    public void setWsdlLocation(String wsdlURL) {
        this.setWsdlURL(wsdlURL);
    }

    public String getWsdlURL() {
        return this.clientFactoryBean.getServiceFactory().getWsdlURL();
    }

    public void setWsdlURL(String wsdlURL) {
        this.clientFactoryBean.getServiceFactory().setWsdlURL(wsdlURL);
    }

    public QName getEndpointName() {
        return this.clientFactoryBean.getEndpointName();
    }

    public void setEndpointName(QName endpointName) {
        this.clientFactoryBean.setEndpointName(endpointName);
    }

    public QName getServiceName() {
        return this.getServiceFactory().getServiceQName();
    }

    public void setServiceName(QName serviceName) {
        this.getServiceFactory().setServiceName(serviceName);
    }

    public String getAddress() {
        return this.clientFactoryBean.getAddress();
    }

    public void setAddress(String add) {
        this.clientFactoryBean.setAddress(add);
    }

    public ConduitSelector getConduitSelector() {
        return this.clientFactoryBean.getConduitSelector();
    }

    public void setConduitSelector(ConduitSelector selector) {
        this.clientFactoryBean.setConduitSelector(selector);
    }

    public void setBindingId(String bind) {
        this.clientFactoryBean.setBindingId(bind);
    }

    public String getBindingId() {
        return this.clientFactoryBean.getBindingId();
    }

    public ReflectionServiceFactoryBean getServiceFactory() {
        return this.clientFactoryBean.getServiceFactory();
    }

    public void setServiceFactory(ReflectionServiceFactoryBean sf) {
        this.clientFactoryBean.setServiceFactory(sf);
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public List<AbstractFeature> getFeatures() {
        if (this.features == null) {
            this.features = new ArrayList<AbstractFeature>();
        }
        return this.features;
    }

    public void setFeatures(List<AbstractFeature> features) {
        this.features = features;
    }

    public DataBinding getDataBinding() {
        return this.dataBinding;
    }

    public void setDataBinding(DataBinding dataBinding) {
        this.dataBinding = dataBinding;
    }

    public void setBindingConfig(BindingConfiguration config) {
        this.getClientFactoryBean().setBindingConfig(config);
    }

    public BindingConfiguration getBindingConfig() {
        return this.getClientFactoryBean().getBindingConfig();
    }
}

