/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.frontend;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.BusException;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.databinding.source.AbstractDataBinding;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.frontend.AbstractEndpointFactory;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.URIResolver;
import org.apache.cxf.service.factory.ReflectionServiceFactoryBean;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.BeanInvoker;
import org.apache.cxf.service.invoker.Invoker;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFactoryBean
extends AbstractEndpointFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(ServerFactoryBean.class);
    private Server server;
    private boolean start = true;
    private Object serviceBean;
    private List<String> schemaLocations;
    private Invoker invoker;

    public ServerFactoryBean() {
        this.setServiceFactory(new ReflectionServiceFactoryBean());
    }

    public String getBeanName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public Server create() {
        try {
            this.applyExtraClass();
            if (this.serviceBean != null && this.getServiceClass() == null) {
                this.setServiceClass(this.serviceBean.getClass());
            }
            Endpoint ep = this.createEndpoint();
            this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
            if (this.invoker == null) {
                if (this.serviceBean != null) {
                    ep.getService().setInvoker(this.createInvoker());
                }
            } else {
                ep.getService().setInvoker(this.invoker);
            }
            if (this.start) {
                this.server.start();
            }
        }
        catch (EndpointException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (BusException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        catch (IOException e) {
            throw new ServiceConstructionException((Throwable)e);
        }
        if (this.getServiceBean() != null) {
            this.initializeAnnotationInterceptors(this.server.getEndpoint(), this.getServiceBean().getClass());
        }
        this.applyFeatures();
        return this.server;
    }

    @Override
    protected void initializeServiceFactory() {
        super.initializeServiceFactory();
        DataBinding db = this.getServiceFactory().getDataBinding();
        if (db instanceof AbstractDataBinding && this.schemaLocations != null) {
            ResourceManager rr = (ResourceManager)this.getBus().getExtension(ResourceManager.class);
            ArrayList<DOMSource> schemas = new ArrayList<DOMSource>();
            for (String l : this.schemaLocations) {
                Document d;
                URL url = (URL)rr.resolveResource(l, URL.class);
                if (url == null) {
                    URIResolver res;
                    try {
                        res = new URIResolver(l);
                    }
                    catch (IOException e) {
                        throw new ServiceConstructionException(new Message("INVALID_SCHEMA_URL", LOG, new Object[0]), (Throwable)e);
                    }
                    if (!res.isResolved()) {
                        throw new ServiceConstructionException(new Message("INVALID_SCHEMA_URL", LOG, new Object[0]));
                    }
                    url = res.getURL();
                }
                try {
                    d = DOMUtils.readXml((InputStream)url.openStream());
                }
                catch (Exception e) {
                    throw new ServiceConstructionException(new Message("ERROR_READING_SCHEMA", LOG, new Object[]{l}), (Throwable)e);
                }
                schemas.add(new DOMSource(d, url.toString()));
            }
            ((AbstractDataBinding)db).setSchemas(schemas);
        }
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (AbstractFeature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected void applyExtraClass() {
        Map<String, Object> props;
        DataBinding dataBinding = this.getServiceFactory().getDataBinding();
        if (dataBinding instanceof JAXBDataBinding && (props = this.getProperties()) != null && props.get("jaxb.additionalContextClasses") != null) {
            Class[] extraClass = (Class[])this.getProperties().get("jaxb.additionalContextClasses");
            ((JAXBDataBinding)dataBinding).setExtraClass(extraClass);
        }
    }

    protected Invoker createInvoker() {
        return new BeanInvoker(this.serviceBean);
    }

    public Server getServer() {
        return this.server;
    }

    public void setServer(Server server) {
        this.server = server;
    }

    public boolean isStart() {
        return this.start;
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    public Object getServiceBean() {
        if (this.serviceBean == null) {
            return this.getServiceFactory().getServiceClass();
        }
        return this.serviceBean;
    }

    public void setServiceBean(Object serviceBean) {
        this.serviceBean = serviceBean;
    }

    public List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSchemaLocations(List<String> schemaLocations) {
        this.schemaLocations = schemaLocations;
    }

    public Invoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }
}

