/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom.deliverer;

import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Feed;
import org.apache.commons.lang.Validate;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.provider.AbstractAtomProvider;
import org.apache.cxf.jaxrs.provider.AtomEntryProvider;
import org.apache.cxf.jaxrs.provider.AtomFeedProvider;
import org.apache.cxf.management.web.logging.atom.deliverer.Deliverer;

public final class WebClientDeliverer
implements Deliverer {
    private WebClient wc;

    public WebClientDeliverer(String deliveryAddress) {
        Validate.notEmpty((String)deliveryAddress, (String)"deliveryAddress is empty or null");
        List<AbstractAtomProvider> providers = Arrays.asList(new AtomFeedProvider(), new AtomEntryProvider());
        this.wc = WebClient.create((String)deliveryAddress, providers);
    }

    public WebClientDeliverer(WebClient wc) {
        Validate.notNull((Object)wc, (String)"wc is null");
        this.wc = wc;
    }

    public boolean deliver(Element element) {
        String type = element instanceof Feed ? "application/atom+xml" : "application/atom+xml;type=entry";
        this.wc.type(type);
        Response res = this.wc.post((Object)element);
        int status = res.getStatus();
        return status >= 200 && status <= 299;
    }

    public String getEndpointAddress() {
        return this.wc.getBaseURI().toString();
    }
}

