/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui.browser;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.Nonnull;
import org.apache.cxf.management.web.browser.client.EventBus;
import org.apache.cxf.management.web.browser.client.event.ChangedFilterOptionsEvent;
import org.apache.cxf.management.web.browser.client.service.browser.FilterOptions;
import org.apache.cxf.management.web.browser.client.ui.BasePresenter;
import org.apache.cxf.management.web.browser.client.ui.BindStrategy;
import org.apache.cxf.management.web.browser.client.ui.browser.EditCriteriaView;

@Singleton
public class EditCriteriaPresenter
extends BasePresenter
implements EditCriteriaView.Presenter {
    @Nonnull
    private final EditCriteriaView view;

    @Inject
    public EditCriteriaPresenter(@Nonnull EventBus eventBus, @Nonnull EditCriteriaView view, @Nonnull @Named(value="BindStrategyForEditCriteria") BindStrategy bindStrategy) {
        super(eventBus, view, bindStrategy);
        this.view = view;
        this.view.setPresenter(this);
    }

    public void onSaveButtonClicked() {
        String phrase = (String)this.view.getPhraseValue().getValue();
        Date from = (Date)this.view.getFromValue().getValue();
        Date to = (Date)this.view.getToValue().getValue();
        ArrayList<FilterOptions.Level> acceptedLevels = new ArrayList<FilterOptions.Level>();
        if (((Boolean)this.view.getDebugValue().getValue()).booleanValue()) {
            acceptedLevels.add(FilterOptions.Level.DEBUG);
        }
        if (((Boolean)this.view.getInfoValue().getValue()).booleanValue()) {
            acceptedLevels.add(FilterOptions.Level.INFO);
        }
        if (((Boolean)this.view.getWarnValue().getValue()).booleanValue()) {
            acceptedLevels.add(FilterOptions.Level.WARN);
        }
        if (((Boolean)this.view.getErrorValue().getValue()).booleanValue()) {
            acceptedLevels.add(FilterOptions.Level.ERROR);
        }
        FilterOptions filterOptions = from == null && to == null && acceptedLevels.isEmpty() ? FilterOptions.EMPTY : new FilterOptions(phrase, from, to, acceptedLevels);
        this.eventBus.fireEvent(new ChangedFilterOptionsEvent(filterOptions));
    }
}

