/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.service.browser;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.XMLParser;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.service.AbstractCallback;
import org.apache.cxf.management.web.browser.client.service.browser.Feed;
import org.apache.cxf.management.web.browser.client.service.browser.FeedProxy;

public class FeedProxyImpl
implements FeedProxy {
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String ATOM_TYPE = "application/atom+xml";

    @Override
    public void getFeed(@Nonnull String url, @Nonnull RequestCallback callback) {
        RequestBuilder builder = this.buildRequest(RequestBuilder.GET, url);
        try {
            builder.sendRequest(null, callback);
        }
        catch (RequestException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Nonnull
    private RequestBuilder buildRequest(@Nonnull RequestBuilder.Method method, @Nonnull String url) {
        assert (!"".equals(url));
        RequestBuilder builder = new RequestBuilder(method, url);
        builder.setHeader(CONTENT_TYPE_HEADER, ATOM_TYPE);
        builder.setHeader(ACCEPT_HEADER, ATOM_TYPE);
        return builder;
    }

    public static abstract class Callback
    extends AbstractCallback<Feed> {
        @Override
        @Nonnull
        protected Feed parse(@Nonnull Response response) {
            Document document = this.convertFromXML(response);
            if (document != null) {
                return new Feed(document);
            }
            return Feed.EMPTY;
        }

        @Nullable
        private Document convertFromXML(@Nonnull Response response) {
            if (response.getText() != null) {
                return XMLParser.parse((String)response.getText());
            }
            return null;
        }
    }
}

