/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.service.settings;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.service.AbstractCallback;
import org.apache.cxf.management.web.browser.client.service.settings.RemoteStorageProxy;
import org.apache.cxf.management.web.browser.client.service.settings.Settings;
import org.apache.cxf.management.web.browser.client.service.settings.Subscription;

public class RemoteStorageProxyImpl
implements RemoteStorageProxy {
    private static final String HOSTED_MODE_ENDPOINT_URL = "settings";
    private static final String RESOURCES_ENDPOINT_SUFFIX = "/resources/";
    private static final String SETTINGS_ENDPOINT_SUFFIX = "/settings";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String JSON_TYPE = "application/json";
    private static final String SETTINGS_KEY = "settings";
    private String endpointURL;

    @Override
    public void saveSettings(@Nonnull RequestCallback callback) {
        RequestBuilder builder = this.buildRequest(RequestBuilder.GET, this.buildEndpointURL());
        this.execute(null, builder, callback);
    }

    @Override
    public void retrieveSettings(@Nonnull Settings settings, @Nonnull RequestCallback callback) {
        RequestBuilder builder = this.buildRequest(RequestBuilder.PUT, this.buildEndpointURL());
        this.execute(Converter.convertToRemoteSettings(settings), builder, callback);
    }

    @Nonnull
    private String buildEndpointURL() {
        if (this.endpointURL == null) {
            String baseURL = GWT.getHostPageBaseURL();
            this.endpointURL = baseURL.endsWith(RESOURCES_ENDPOINT_SUFFIX) ? this.cutResourcesSuffix(baseURL) + SETTINGS_ENDPOINT_SUFFIX : "settings";
        }
        return this.endpointURL;
    }

    @Nonnull
    private String cutResourcesSuffix(@Nonnull String url) {
        return url.substring(0, url.lastIndexOf(RESOURCES_ENDPOINT_SUFFIX));
    }

    @Nonnull
    private RequestBuilder buildRequest(@Nonnull RequestBuilder.Method method, @Nonnull String url) {
        assert (!"".equals(url));
        RequestBuilder builder = new RequestBuilder(method, url);
        builder.setHeader(CONTENT_TYPE_HEADER, JSON_TYPE);
        builder.setHeader(ACCEPT_HEADER, JSON_TYPE);
        return builder;
    }

    private void execute(@Nullable RemoteSettings remoteSettings, @Nonnull RequestBuilder builder, @Nonnull RequestCallback callback) {
        String json = null;
        if (remoteSettings != null) {
            JSONObject rootElement = new JSONObject();
            rootElement.put("settings", (JSONValue)new JSONObject((JavaScriptObject)remoteSettings));
            json = rootElement.toString();
        }
        try {
            builder.sendRequest(json, callback);
        }
        catch (RequestException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static class NoActionCallback
    extends AbstractCallback<Settings> {
        @Override
        public void onSuccess(@Nullable Settings obj) {
        }

        @Override
        @Nullable
        protected Settings parse(@Nonnull Response response) {
            return null;
        }
    }

    public static abstract class Callback
    extends AbstractCallback<Settings> {
        @Override
        @Nullable
        protected Settings parse(@Nonnull Response response) {
            JSONValue rootElement;
            RemoteSettings result = null;
            if (response.getText() != null && !"".equals(response.getText()) && (rootElement = new JSONObject(this.convertFromJSON(response.getText())).get("settings")) != null && rootElement.isObject() != null) {
                result = (RemoteSettings)rootElement.isObject().getJavaScriptObject();
            }
            return result != null ? Converter.convertToSettings(result) : null;
        }

        @Nonnull
        private final native JavaScriptObject convertFromJSON(@Nonnull String var1);
    }

    protected static final class Converter {
        private Converter() {
        }

        @Nonnull
        public static Settings convertToSettings(@Nonnull RemoteSettings remoteSettings) {
            Settings settings = new Settings();
            JsArray<RemoteSubscription> remoteSubscriptions = remoteSettings.getSubscriptions();
            for (int i = 0; i < remoteSubscriptions.length(); ++i) {
                settings.getSubscriptions().add(Converter.convertToSubscription((RemoteSubscription)remoteSubscriptions.get(i)));
            }
            return settings;
        }

        @Nonnull
        public static Subscription convertToSubscription(@Nonnull RemoteSubscription remoteSubscription) {
            return new Subscription(remoteSubscription.getId(), remoteSubscription.getName(), remoteSubscription.getUrl());
        }

        @Nonnull
        public static RemoteSettings convertToRemoteSettings(@Nonnull Settings settings) {
            RemoteSettings remoteSettings = (RemoteSettings)JavaScriptObject.createObject();
            JsArray remoteSubscriptions = (JsArray)JavaScriptObject.createArray();
            for (Subscription subscription : settings.getSubscriptions()) {
                remoteSubscriptions.push((JavaScriptObject)Converter.convertToRemoteSubscription(subscription));
            }
            remoteSettings.setSubscriptions((JsArray<RemoteSubscription>)remoteSubscriptions);
            return remoteSettings;
        }

        @Nonnull
        public static RemoteSubscription convertToRemoteSubscription(@Nonnull Subscription subscription) {
            RemoteSubscription remoteSubscription = (RemoteSubscription)JavaScriptObject.createObject();
            remoteSubscription.setId(subscription.getId());
            remoteSubscription.setName(subscription.getName());
            remoteSubscription.setUrl(subscription.getUrl());
            return remoteSubscription;
        }
    }

    protected static class RemoteSubscription
    extends JavaScriptObject {
        protected RemoteSubscription() {
        }

        public final native void setId(@Nullable String var1);

        @Nullable
        public final native String getId();

        public final native void setUrl(@Nullable String var1);

        @Nullable
        public final native String getUrl();

        public final native void setName(@Nullable String var1);

        @Nullable
        public final native String getName();
    }

    protected static class RemoteSettings
    extends JavaScriptObject {
        protected RemoteSettings() {
        }

        public final native void setSubscriptions(@Nullable JsArray<RemoteSubscription> var1);

        @Nonnull
        public final native JsArray<RemoteSubscription> getSubscriptions();
    }
}

