/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.browser.client.ui.browser;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.cxf.management.web.browser.client.ui.resources.LogBrowserResources;

public class SelectableTable<T>
extends Composite {
    @Nonnull
    private final ScrollPanel scroller;
    @Nullable
    private final FocusPanel focuser;
    @Nonnull
    private final FlexTable table;
    @Nonnull
    private final List<SelectRowHandler> selectRowHandlers;
    private final boolean hotkeysEnabled;
    private int selectedRowIndex;
    private boolean isRowSelected;
    private Label messageLabel;
    @Nullable
    private List<ColumnDefinition<T>> columnDefinitions;
    @Nonnull
    private LogBrowserResources resources = (LogBrowserResources)GWT.create(LogBrowserResources.class);

    public SelectableTable(boolean hotkeysEnabled) {
        this.hotkeysEnabled = hotkeysEnabled;
        this.selectRowHandlers = new ArrayList<SelectRowHandler>();
        this.table = new FlexTable();
        this.table.setCellPadding(0);
        this.table.setCellSpacing(0);
        this.table.setVisible(false);
        this.messageLabel = new Label();
        this.messageLabel.setVisible(false);
        FlowPanel content = new FlowPanel();
        content.add((Widget)this.messageLabel);
        content.add((Widget)this.table);
        this.scroller = new ScrollPanel();
        if (hotkeysEnabled) {
            this.focuser = new FocusPanel();
            this.focuser.setWidth("99%");
            this.focuser.add((Widget)content);
            this.scroller.add((Widget)this.focuser);
        } else {
            this.focuser = null;
            this.scroller.add((Widget)content);
        }
        this.addEventHandlers();
        this.initWidget((Widget)this.scroller);
    }

    public void setMessageInsteadOfData(@Nonnull String message, @Nullable String styleName) {
        this.messageLabel.setText(message);
        this.messageLabel.setVisible(true);
        this.table.setVisible(false);
        if (styleName != null) {
            this.messageLabel.setStyleName(styleName);
        }
    }

    public void setData(@Nonnull List<T> entries) {
        assert (this.columnDefinitions != null);
        this.table.removeAllRows();
        this.messageLabel.setVisible(false);
        this.table.setVisible(true);
        for (int i = 0; i < entries.size(); ++i) {
            T entry = entries.get(i);
            for (int j = 0; j < this.columnDefinitions.size(); ++j) {
                ColumnDefinition<T> columnDefinition = this.columnDefinitions.get(j);
                this.table.setText(i, j, columnDefinition.getContent(entry));
                this.table.getCellFormatter().addStyleName(i, j, this.resources.css().selectableTableRow());
            }
        }
        this.restoreRowSelection();
        if (this.hotkeysEnabled) {
            this.focuser.setFocus(true);
        }
    }

    public void setColumnDefinitions(@Nonnull List<ColumnDefinition<T>> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
        this.setColumnsWidth();
    }

    public void setColumnDefinitions(ColumnDefinition<T> ... columnDefinitions) {
        this.columnDefinitions = Arrays.asList(columnDefinitions);
        this.setColumnsWidth();
    }

    public void addSelectRowHandler(@Nonnull SelectRowHandler selectRowHandler) {
        this.selectRowHandlers.add(selectRowHandler);
    }

    public void deselect() {
        if (this.table.getRowCount() > 0) {
            this.styleRow(this.selectedRowIndex, false);
            this.selectedRowIndex = 0;
            this.isRowSelected = false;
        }
    }

    private void addEventHandlers() {
        this.table.addClickHandler(new ClickHandler(){

            public void onClick(@Nonnull ClickEvent event) {
                SelectableTable.this.performClickAction(event);
            }
        });
        if (this.hotkeysEnabled) {
            this.focuser.addKeyDownHandler(new KeyDownHandler(){

                public void onKeyDown(@Nonnull KeyDownEvent event) {
                    SelectableTable.this.performKeyDownAction(event);
                }
            });
        }
    }

    private void performClickAction(@Nonnull ClickEvent event) {
        HTMLTable.Cell cell = this.table.getCellForEvent(event);
        if (cell != null) {
            int row = cell.getRowIndex();
            this.selectRow(row);
        }
    }

    private void performKeyDownAction(@Nonnull KeyDownEvent event) {
        if (this.isRowSelected) {
            event.preventDefault();
            if (event.isUpArrow()) {
                this.selectRow(this.selectedRowIndex - 1);
            } else if (event.isDownArrow()) {
                this.selectRow(this.selectedRowIndex + 1);
            }
            ScrollMarker scrollMarker = new ScrollMarker((Element)this.table.getRowFormatter().getElement(this.selectedRowIndex));
            this.scroller.ensureVisible((UIObject)scrollMarker);
        }
    }

    private void selectRow(int row) {
        if (row >= 0 && row < this.table.getRowCount()) {
            if (this.isRowSelected) {
                this.styleRow(this.selectedRowIndex, false);
            }
            this.selectedRowIndex = row;
            this.styleRow(this.selectedRowIndex, true);
            this.isRowSelected = true;
            this.fireSelectRowEvent();
        }
    }

    private void styleRow(int row, boolean selected) {
        String style = this.resources.css().browserTabSelectedRow();
        if (selected) {
            this.table.getRowFormatter().addStyleName(row, style);
        } else {
            this.table.getRowFormatter().removeStyleName(row, style);
        }
    }

    private void fireSelectRowEvent() {
        for (SelectRowHandler selectRowHandler : this.selectRowHandlers) {
            selectRowHandler.onSelectRow(this.selectedRowIndex);
        }
    }

    private void restoreRowSelection() {
        if (this.isRowSelected && this.selectedRowIndex < this.table.getRowCount()) {
            this.selectRow(this.selectedRowIndex);
        } else {
            this.isRowSelected = false;
        }
    }

    private void setColumnsWidth() {
        assert (this.columnDefinitions != null);
        for (int j = 0; j < this.columnDefinitions.size(); ++j) {
            ColumnDefinition<T> columnDefinition = this.columnDefinitions.get(j);
            this.table.getColumnFormatter().setWidth(j, columnDefinition.getWidth());
        }
    }

    public static interface ColumnDefinition<T> {
        public String getContent(T var1);

        public String getWidth();
    }

    public static interface SelectRowHandler {
        public void onSelectRow(int var1);
    }

    private class ScrollMarker
    extends UIObject {
        public ScrollMarker(Element element) {
            this.setElement(element);
        }
    }
}

