/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.web.logging.atom;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Handler;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Feed;
import org.apache.commons.lang.Validate;
import org.apache.cxf.jaxrs.ext.StreamingResponse;
import org.apache.cxf.management.web.logging.atom.AbstractAtomBean;
import org.apache.cxf.management.web.logging.atom.AtomPushEngineConfigurator;
import org.apache.cxf.management.web.logging.atom.AtomPushHandler;
import org.apache.cxf.management.web.logging.atom.converter.Converter;
import org.apache.cxf.management.web.logging.atom.deliverer.Deliverer;

@Path(value="/logs2")
public final class AtomPushOverWebSocketServer
extends AbstractAtomBean {
    private AtomPushEngineConfigurator conf = new AtomPushEngineConfigurator();
    private Map<String, Object> activeStreams;

    public AtomPushOverWebSocketServer() {
        this.conf.setDeliverer(new WebSocketDeliverer());
    }

    @Override
    public void init() {
        super.init();
        this.activeStreams = Collections.synchronizedMap(new HashMap());
    }

    public void setConverter(Converter converter) {
        this.checkInit();
        Validate.notNull((Object)converter, (String)"converter is null");
        this.conf.setConverter(converter);
    }

    public void setBatchSize(String batchSize) {
        this.checkInit();
        Validate.notNull((Object)batchSize, (String)"batchSize is null");
        this.conf.setBatchSize(batchSize);
    }

    public void setBatchCleanupTime(String batchCleanupTime) {
        this.checkInit();
        Validate.notNull((Object)batchCleanupTime, (String)"batchCleanup is null");
        this.conf.setBatchCleanupTime(batchCleanupTime);
    }

    public void setRetryPause(String retryPause) {
        this.checkInit();
        Validate.notNull((Object)retryPause, (String)"retryPause is null");
        this.conf.setRetryPause(retryPause);
    }

    public void setRetryPauseTime(String time) {
        this.checkInit();
        Validate.notNull((Object)time, (String)"time is null");
        this.conf.setRetryPauseTime(time);
    }

    public void setRetryTimeout(String timeout) {
        this.checkInit();
        Validate.notNull((Object)timeout, (String)"timeout is null");
        this.conf.setRetryTimeout(timeout);
    }

    public void setOutput(String output) {
        this.checkInit();
        Validate.notNull((Object)output, (String)"output is null");
        this.conf.setOutput(output);
    }

    public void setMultiplicity(String multiplicity) {
        this.checkInit();
        Validate.notNull((Object)multiplicity, (String)"multiplicity is null");
        this.conf.setMultiplicity(multiplicity);
    }

    public void setFormat(String format) {
        this.checkInit();
        Validate.notNull((Object)format, (String)"format is null");
        this.conf.setFormat(format);
    }

    @Override
    protected Handler createHandler() {
        return new AtomPushHandler(this.conf.createEngine());
    }

    @GET
    @Produces(value={"application/atom+xml"})
    @Path(value="subscribe")
    public StreamingResponse<Feed> subscribeXmlFeed(@HeaderParam(value="requestId") String reqid) {
        final String key = reqid == null ? "*" : reqid;
        return new StreamingResponse<Feed>(){

            public void writeTo(StreamingResponse.Writer<Feed> out) throws IOException {
                AtomPushOverWebSocketServer.this.activeStreams.put(key, out);
            }
        };
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="unsubscribe/{key}")
    public Boolean unsubscribeXmlFeed(@PathParam(value="key") String key) {
        return this.activeStreams.remove(key) != null;
    }

    private class WebSocketDeliverer
    implements Deliverer {
        private WebSocketDeliverer() {
        }

        @Override
        public boolean deliver(Element element) throws InterruptedException {
            if (AtomPushOverWebSocketServer.this.activeStreams.size() > 0) {
                Iterator it = AtomPushOverWebSocketServer.this.activeStreams.values().iterator();
                while (it.hasNext()) {
                    Object out = it.next();
                    try {
                        if (!(out instanceof StreamingResponse.Writer)) continue;
                        ((StreamingResponse.Writer)out).write((Object)element);
                    }
                    catch (Throwable t) {
                        System.err.print("ERROR | AtomPushOverWebSocketServer | " + t + "; Unregistering " + out);
                        it.remove();
                    }
                }
            }
            return true;
        }

        @Override
        public String getEndpointAddress() {
            return null;
        }
    }
}

