/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.jmx;

import java.io.IOException;
import java.rmi.registry.LocateRegistry;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MBServerConnectorFactory {
    public static final String DEFAULT_SERVICE_URL = "service:jmx:rmi:///jndi/rmi://localhost:9913/jmxrmi";
    private static final Logger LOG = LogUtils.getL7dLogger(MBServerConnectorFactory.class);
    private static MBServerConnectorFactory factory;
    private static MBeanServer server;
    private static String serviceUrl;
    private static Map<String, ?> environment;
    private static boolean threaded;
    private static boolean daemon;
    private static JMXConnectorServer connectorServer;

    private MBServerConnectorFactory() {
    }

    private int getURLLocalHostPort(String url) {
        int portEnd;
        int portStart = url.indexOf("localhost") + 10;
        int port = 0;
        if (portStart > 0 && (portEnd = MBServerConnectorFactory.indexNotOfNumber(url, portStart)) > portStart) {
            String portString = url.substring(portStart, portEnd);
            port = Integer.parseInt(portString);
        }
        return port;
    }

    private static int indexNotOfNumber(String str, int index) {
        int i = 0;
        for (i = index; i < str.length(); ++i) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') continue;
            return i;
        }
        return -1;
    }

    public static MBServerConnectorFactory getInstance() {
        if (factory == null) {
            factory = new MBServerConnectorFactory();
        }
        return factory;
    }

    public void setMBeanServer(MBeanServer ms) {
        server = ms;
    }

    public void setServiceUrl(String url) {
        serviceUrl = url;
    }

    public void setEnvironment(Map<String, ?> env) {
        environment = env;
    }

    public void setThreaded(boolean fthread) {
        threaded = fthread;
    }

    public void setDaemon(boolean fdaemon) {
        daemon = fdaemon;
    }

    public void createConnector() throws IOException {
        if (server == null) {
            server = MBeanServerFactory.createMBeanServer();
        }
        JMXServiceURL url = new JMXServiceURL(serviceUrl);
        if (serviceUrl.indexOf("localhost") > -1 && url.getProtocol().compareToIgnoreCase("rmi") == 0) {
            try {
                int port = this.getURLLocalHostPort(serviceUrl);
                try {
                    LocateRegistry.createRegistry(port);
                }
                catch (Exception ex) {
                    LocateRegistry.getRegistry(port);
                }
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "CREATE_REGISTRY_FAULT_MSG", new Object[]{ex});
            }
        }
        connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, environment, server);
        if (threaded) {
            Thread connectorThread = new Thread(){

                public void run() {
                    try {
                        connectorServer.start();
                    }
                    catch (IOException ex) {
                        LOG.log(Level.SEVERE, "START_CONNECTOR_FAILURE_MSG", new Object[]{ex});
                    }
                }
            };
            connectorThread.setName("JMX Connector Thread [" + serviceUrl + "]");
            connectorThread.setDaemon(daemon);
            connectorThread.start();
        } else {
            connectorServer.start();
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("JMX connector server started: " + connectorServer);
        }
    }

    public void destroy() throws IOException {
        connectorServer.stop();
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("JMX connector server stoped: " + connectorServer);
        }
    }

    static {
        serviceUrl = DEFAULT_SERVICE_URL;
    }
}

