/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.event.Event;
import org.apache.cxf.event.EventCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventCacheImpl
implements EventCache {
    public static final String MAX_EVENTS = "bus:events:cache:size";
    private static final Logger LOG = Logger.getLogger(EventCacheImpl.class.getName());
    private List<Event> events;
    private int maxEventsCache = 100;

    public EventCacheImpl() {
        this.initCache();
    }

    private void initCache() {
        this.events = new ArrayList<Event>(this.maxEventsCache);
    }

    public synchronized void addEvent(Event e) {
        if (this.events.size() == this.maxEventsCache) {
            Event event = this.events.get(0);
            LOG.log(Level.FINE, "Event " + event.getID() + " is removed because the event cache is full." + " Maximum number of events stored : " + this.maxEventsCache);
            this.events.remove(event);
        }
        this.events.add(e);
    }

    public synchronized List<Event> flushEvents() {
        ArrayList<Event> result = new ArrayList<Event>(this.events.size());
        result.addAll(this.events);
        this.events.clear();
        return result;
    }

    public synchronized List<Event> flushEvents(QName eventType) {
        ArrayList<Event> result = new ArrayList<Event>();
        Iterator<Event> i = this.events.iterator();
        while (i.hasNext()) {
            Event event = i.next();
            if (!eventType.equals(event.getID())) continue;
            result.add(event);
            i.remove();
        }
        return result;
    }

    public synchronized List<Event> flushEvents(String namespaceURI) {
        ArrayList<Event> result = new ArrayList<Event>();
        Iterator<Event> i = this.events.iterator();
        while (i.hasNext()) {
            Event event = i.next();
            if (!namespaceURI.equals(event.getID().getNamespaceURI())) continue;
            result.add(event);
            i.remove();
        }
        return result;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<Event> getEvents(QName eventType) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (int i = 0; i < this.events.size(); ++i) {
            Event event = this.events.get(i);
            if (!eventType.equals(event.getID())) continue;
            result.add(event);
        }
        return result;
    }

    public List<Event> getEvents(String namespaceURI) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (int i = 0; i < this.events.size(); ++i) {
            Event event = this.events.get(i);
            if (!namespaceURI.equals(event.getID().getNamespaceURI())) continue;
            result.add(event);
        }
        return result;
    }

    public void setCacheSize(int size) {
        this.maxEventsCache = size;
        ((ArrayList)this.events).ensureCapacity(this.maxEventsCache);
    }
}

