/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.event;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.cxf.Bus;
import org.apache.cxf.event.Event;
import org.apache.cxf.event.EventCache;
import org.apache.cxf.event.EventCacheImpl;
import org.apache.cxf.event.EventFilter;
import org.apache.cxf.event.EventListener;
import org.apache.cxf.event.EventProcessor;

public class EventProcessorImpl
implements EventProcessor {
    protected List<EventListenerInfo> listenerList = new ArrayList<EventListenerInfo>();
    protected EventCache cache;
    private Bus bus;

    public EventProcessorImpl() {
        this(null);
    }

    public EventProcessorImpl(EventCache eventCache) {
        this.cache = eventCache == null ? new EventCacheImpl() : eventCache;
    }

    @Resource(name="bus")
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, EventProcessor.class);
        }
    }

    public void addEventListener(EventListener l) {
        this.addEventListener(l, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(EventListener l, EventFilter filter) {
        if (l == null) {
            return;
        }
        List<EventListenerInfo> list = this.listenerList;
        synchronized (list) {
            this.listenerList.add(new EventListenerInfo(l, filter));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(EventListener l) {
        List<EventListenerInfo> list = this.listenerList;
        synchronized (list) {
            Iterator<EventListenerInfo> i = this.listenerList.iterator();
            while (i.hasNext()) {
                EventListenerInfo li = i.next();
                if (li.listener != l) continue;
                i.remove();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(Event e) {
        if (e == null) {
            return;
        }
        boolean eventProcessed = false;
        List<EventListenerInfo> list = this.listenerList;
        synchronized (list) {
            for (int i = 0; i < this.listenerList.size(); ++i) {
                EventListenerInfo li = this.listenerList.get(i);
                if (li.filter != null && !li.filter.isEventEnabled(e)) continue;
                eventProcessed = true;
                li.listener.processEvent(e);
            }
        }
        if (!eventProcessed) {
            this.cache.addEvent(e);
        }
    }

    class EventListenerInfo {
        EventListener listener;
        EventFilter filter;

        public EventListenerInfo(EventListener l, EventFilter f) {
            this.listener = l;
            this.filter = f;
        }
    }
}

