/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.management.MBeanServer;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.event.ComponentEventFilter;
import org.apache.cxf.event.Event;
import org.apache.cxf.event.EventFilter;
import org.apache.cxf.event.EventListener;
import org.apache.cxf.event.EventProcessor;
import org.apache.cxf.management.Instrumentation;
import org.apache.cxf.management.InstrumentationFactory;
import org.apache.cxf.management.InstrumentationManager;
import org.apache.cxf.management.InstrumentationManagerConfigBean;
import org.apache.cxf.management.InstrumentationType;
import org.apache.cxf.management.JMXConnectorPolicyType;
import org.apache.cxf.management.jmx.JMXManagedComponentManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentationManagerImpl
extends InstrumentationManagerConfigBean
implements InstrumentationManager,
EventListener {
    static final Logger LOG = LogUtils.getL7dLogger(InstrumentationManagerImpl.class);
    private Bus bus;
    private List<Instrumentation> instrumentations;
    private JMXManagedComponentManager jmxManagedComponentManager;

    public Bus getBus() {
        return this.bus;
    }

    @Resource(name="bus")
    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @PostConstruct
    public void register() {
        if (null != this.bus) {
            this.bus.setExtension((Object)this, InstrumentationManager.class);
        }
    }

    public String getBeanName() {
        return InstrumentationManager.class.getName();
    }

    @PostConstruct
    public void initInstrumentationManagerImpl() {
        LOG.info("Setting up InstrumentationManager");
        if (null == this.getInstrumentation()) {
            this.setInstrumentation(new InstrumentationType());
        }
        if (null == this.getJMXConnectorPolicy()) {
            this.setJMXConnectorPolicy(new JMXConnectorPolicyType());
        }
        if (this.getInstrumentation().isEnabled()) {
            LOG.fine("Instrumentation is enabled.");
            this.instrumentations = new LinkedList<Instrumentation>();
            ComponentEventFilter componentEventFilter = new ComponentEventFilter();
            EventProcessor ep = (EventProcessor)this.bus.getExtension(EventProcessor.class);
            if (null != ep) {
                ep.addEventListener((EventListener)this, (EventFilter)componentEventFilter);
            }
        }
        if (this.getInstrumentation().isJMXEnabled()) {
            LOG.fine("JMX is enabled.");
            this.jmxManagedComponentManager = new JMXManagedComponentManager();
            this.jmxManagedComponentManager.init(this.getJMXConnectorPolicy());
        }
    }

    public void shutdown() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Shutdown InstrumentationManager");
        }
        if (this.jmxManagedComponentManager != null) {
            this.jmxManagedComponentManager.shutdown();
        }
    }

    public void register(Instrumentation it) {
        if (it == null) {
            return;
        }
        this.instrumentations.add(it);
        if (this.jmxManagedComponentManager != null) {
            this.jmxManagedComponentManager.registerMBean(it);
        }
    }

    public void unregister(Object component) {
        Iterator<Instrumentation> i = this.instrumentations.iterator();
        while (i.hasNext()) {
            Instrumentation it = i.next();
            if (it.getComponent() != component) continue;
            i.remove();
            if (it != null && this.jmxManagedComponentManager != null) {
                this.jmxManagedComponentManager.unregisterMBean(it);
            }
            return;
        }
    }

    public List<Instrumentation> getAllInstrumentation() {
        return this.instrumentations;
    }

    public MBeanServer getMBeanServer() {
        return this.jmxManagedComponentManager.getMBeanServer();
    }

    public void processEvent(Event e) {
        if (e.getID().getLocalPart().equals("cxf.component.created.event")) {
            Instrumentation it = ((InstrumentationFactory)e.getSource()).createInstrumentation();
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Instrumentation register " + e.getSource().getClass().getName());
            }
            this.register(it);
        } else if (e.getID().getLocalPart().equals("cxf.component.removed.event")) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Instrumentation unregister " + e.getSource().getClass().getName());
            }
            this.unregister(e.getSource());
        }
    }
}

