/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.counters;

import java.util.concurrent.atomic.AtomicInteger;
import javax.management.ObjectName;
import org.apache.cxf.management.counters.Counter;
import org.apache.cxf.management.counters.MessageHandlingTimeRecorder;
import org.apache.cxf.management.counters.ResponseTimeCounterMBean;

public class ResponseTimeCounter
implements ResponseTimeCounterMBean,
Counter {
    private ObjectName objectName;
    private AtomicInteger invocations = new AtomicInteger();
    private long totalHandlingTime;
    private long maxHandlingTime;
    private long minHandlingTime = Integer.MAX_VALUE;

    public ResponseTimeCounter(ObjectName on) {
        this.objectName = on;
    }

    public void increase(MessageHandlingTimeRecorder mhtr) {
        this.invocations.getAndIncrement();
        long handlingTime = 0L;
        if (mhtr.isOneWay()) {
            if (mhtr.getEndTime() > 0L) {
                handlingTime = mhtr.getHandlingTime();
            }
        } else {
            handlingTime = mhtr.getHandlingTime();
        }
        this.totalHandlingTime += handlingTime;
        if (this.maxHandlingTime < handlingTime) {
            this.maxHandlingTime = handlingTime;
        }
        if (this.minHandlingTime > handlingTime) {
            this.minHandlingTime = handlingTime;
        }
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public Number getAvgResponseTime() {
        return (int)(this.totalHandlingTime / (long)this.invocations.get());
    }

    public Number getMaxResponseTime() {
        return this.maxHandlingTime;
    }

    public Number getMinResponseTime() {
        return this.minHandlingTime;
    }

    public Number getNumInvocations() {
        return this.invocations.get();
    }
}

