/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.provider.json.JsonMapObject;
import org.apache.cxf.jaxrs.provider.json.JsonMapObjectReaderWriter;

@Produces(value={"application/json", "application/*+json"})
@Consumes(value={"application/json", "application/*+json"})
@Provider
public class JsonMapObjectProvider
implements MessageBodyReader<JsonMapObject>,
MessageBodyWriter<JsonMapObject> {
    private JsonMapObjectReaderWriter handler = new JsonMapObjectReaderWriter();

    public long getSize(JsonMapObject o, Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return -1L;
    }

    public boolean isWriteable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return JsonMapObject.class.isAssignableFrom(cls);
    }

    public void writeTo(JsonMapObject o, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        this.handler.toJson(o, os);
    }

    public boolean isReadable(Class<?> cls, Type t, Annotation[] anns, MediaType mt) {
        return JsonMapObject.class.isAssignableFrom(cls);
    }

    public JsonMapObject readFrom(Class<JsonMapObject> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        String s = IOUtils.readStringFromStream((InputStream)is);
        JsonMapObject obj = new JsonMapObject();
        this.handler.fromJson(obj, s);
        if (cls == JsonMapObject.class) {
            return obj;
        }
        try {
            JsonMapObject actualObj = cls.newInstance();
            actualObj.values = obj.values;
            actualObj.updateCount = obj.updateCount;
            return actualObj;
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
    }
}

