/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.fiql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.cxf.jaxrs.ext.search.AndSearchCondition;
import org.apache.cxf.jaxrs.ext.search.Beanspector;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.InterfaceProxy;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.PropertyNotFoundException;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchConditionParser;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.SimpleSearchCondition;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheck;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.message.MessageUtils;

public class FiqlParser<T>
implements SearchConditionParser<T> {
    public static final String OR = ",";
    public static final String AND = ";";
    public static final String GT = "=gt=";
    public static final String GE = "=ge=";
    public static final String LT = "=lt=";
    public static final String LE = "=le=";
    public static final String EQ = "==";
    public static final String NEQ = "!=";
    public static final Map<ConditionType, String> CONDITION_MAP;
    public static final String EXTENSION_COUNT = "count";
    public static final String SUPPORT_SINGLE_EQUALS = "fiql.support.single.equals.operator";
    private static final String EXTENSION_COUNT_OPEN = "count(";
    private static final Map<String, ConditionType> OPERATORS_MAP;
    private static final Pattern COMPARATORS_PATTERN;
    private static final Pattern COMPARATORS_PATTERN_SINGLE_EQUALS;
    private Beanspector<T> beanspector;
    private Class<T> conditionClass;
    private Map<String, String> contextProperties;
    private Map<String, String> beanPropertiesMap;
    private Map<String, ConditionType> operatorsMap = OPERATORS_MAP;
    private Pattern comparatorsPattern = COMPARATORS_PATTERN;

    public FiqlParser(Class<T> tclass) {
        this(tclass, Collections.emptyMap());
    }

    public FiqlParser(Class<T> tclass, Map<String, String> contextProperties) {
        this(tclass, contextProperties, null);
    }

    public FiqlParser(Class<T> tclass, Map<String, String> contextProperties, Map<String, String> beanProperties) {
        this.beanspector = SearchBean.class.isAssignableFrom(tclass) ? null : new Beanspector<Class<Class<Class<Class<T>>>>>(tclass);
        this.conditionClass = tclass;
        this.contextProperties = contextProperties == null ? Collections.emptyMap() : contextProperties;
        this.beanPropertiesMap = beanProperties;
        if (MessageUtils.isTrue((Object)this.contextProperties.get(SUPPORT_SINGLE_EQUALS))) {
            this.operatorsMap = new HashMap<String, ConditionType>(this.operatorsMap);
            this.operatorsMap.put("=", ConditionType.EQUALS);
            this.comparatorsPattern = COMPARATORS_PATTERN_SINGLE_EQUALS;
        }
    }

    @Override
    public SearchCondition<T> parse(String fiqlExpression) throws SearchParseException {
        ASTNode<T> ast = this.parseAndsOrsBrackets(fiqlExpression);
        return ast.build();
    }

    private ASTNode<T> parseAndsOrsBrackets(String expr) throws SearchParseException {
        ArrayList<String> subexpressions = new ArrayList<String>();
        ArrayList<String> operators = new ArrayList<String>();
        int level = 0;
        int lastIdx = 0;
        int idx = 0;
        for (idx = 0; idx < expr.length(); ++idx) {
            boolean isEnd;
            boolean isOperator;
            char c = expr.charAt(idx);
            if (c == '(') {
                ++level;
            } else if (c == ')' && --level < 0) {
                throw new SearchParseException(String.format("Unexpected closing bracket at position %d", idx));
            }
            String cs = Character.toString(c);
            boolean bl = isOperator = AND.equals(cs) || OR.equals(cs);
            if (level == 0 && isOperator) {
                String s1 = expr.substring(lastIdx, idx);
                String s2 = expr.substring(idx, idx + 1);
                subexpressions.add(s1);
                operators.add(s2);
                lastIdx = idx + 1;
            }
            boolean bl2 = isEnd = idx == expr.length() - 1;
            if (!isEnd) continue;
            String s1 = expr.substring(lastIdx, idx + 1);
            subexpressions.add(s1);
            operators.add(null);
            lastIdx = idx + 1;
        }
        if (level != 0) {
            throw new SearchParseException(String.format("Unmatched opening and closing brackets in expression: %s", expr));
        }
        if (operators.get(operators.size() - 1) != null) {
            String op = (String)operators.get(operators.size() - 1);
            String ex = (String)subexpressions.get(subexpressions.size() - 1);
            throw new SearchParseException("Dangling operator at the end of expression: ..." + ex + op);
        }
        int from = 0;
        int to = 0;
        SubExpression ors = new SubExpression(OR);
        while (to < operators.size()) {
            while (to < operators.size() && AND.equals(operators.get(to))) {
                ++to;
            }
            SubExpression ands = new SubExpression(AND);
            while (from <= to) {
                String subex = (String)subexpressions.get(from);
                ASTNode node = null;
                node = subex.startsWith("(") ? this.parseAndsOrsBrackets(subex.substring(1, subex.length() - 1)) : this.parseComparison(subex);
                if (node != null) {
                    ands.add(node);
                }
                ++from;
            }
            to = from;
            if (ands.getSubnodes().size() == 1) {
                ors.add(ands.getSubnodes().get(0));
                continue;
            }
            ors.add(ands);
        }
        if (ors.getSubnodes().size() == 1) {
            return ors.getSubnodes().get(0);
        }
        return ors;
    }

    private Comparison parseComparison(String expr) throws SearchParseException {
        Matcher m = this.comparatorsPattern.matcher(expr);
        if (m.find()) {
            TypeInfoObject castedValue;
            String beanPropertyName;
            String propertyName = expr.substring(0, m.start(1));
            String operator = m.group(1);
            String value = expr.substring(m.end(1));
            if ("".equals(value)) {
                throw new SearchParseException("Not a comparison expression: " + expr);
            }
            String name = this.unwrapSetter(propertyName);
            String string = beanPropertyName = this.beanPropertiesMap == null ? null : this.beanPropertiesMap.get(name);
            if (beanPropertyName != null) {
                name = beanPropertyName;
            }
            if ((castedValue = this.parseType(propertyName, name, value)) != null) {
                return new Comparison(name, operator, castedValue);
            }
            if (MessageUtils.isTrue((Object)this.contextProperties.get("search.lax.property.match"))) {
                return null;
            }
            throw new PropertyNotFoundException(name, value);
        }
        throw new SearchParseException("Not a comparison expression: " + expr);
    }

    private TypeInfoObject parseType(String originalName, String setter, String value) throws SearchParseException {
        String name = this.getSetter(setter);
        try {
            Beanspector.TypeInfo typeInfo = this.beanspector != null ? this.beanspector.getAccessorTypeInfo(name) : new Beanspector.TypeInfo(String.class, (Type)((Object)String.class));
            Object object = this.parseType(originalName, null, null, setter, typeInfo, value);
            return new TypeInfoObject(object, typeInfo);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    private Object parseType(String originalPropName, Object ownerBean, Object lastCastedValue, String setter, Beanspector.TypeInfo typeInfo, String value) throws SearchParseException {
        valueType = typeInfo.getTypeClass();
        isCollection = InjectionUtils.isSupportedCollectionOrArray(valueType);
        actualType = isCollection != false ? InjectionUtils.getActualType((Type)typeInfo.getGenericType()) : valueType;
        index = this.getDotIndex(setter);
        if (index == -1) {
            castedValue = value;
            if (Date.class.isAssignableFrom(valueType)) {
                castedValue = this.convertToDate(value);
            } else {
                isPrimitive = InjectionUtils.isPrimitive((Class)valueType);
                v0 = isPrimitiveOrEnum = isPrimitive != false || valueType.isEnum() != false;
                if (ownerBean == null || isPrimitiveOrEnum) {
                    try {
                        collCheck = this.getCollectionCheck(originalPropName, isCollection, actualType);
                        if (collCheck == null) {
                            castedValue = InjectionUtils.convertStringToPrimitive((String)value, actualType);
                        }
                        if (collCheck == null && isCollection) {
                            castedValue = this.getCollectionSingleton(valueType, castedValue);
                        }
                        if (!isCollection) ** GOTO lbl36
                        typeInfo.setCollectionCheckInfo(new CollectionCheckInfo(collCheck, castedValue));
                        castedValue = this.getEmptyCollection(valueType);
                    }
                    catch (Exception e) {
                        throw new SearchParseException("Cannot convert String value \"" + value + "\" to a value of class " + valueType.getName(), e);
                    }
                } else {
                    classType = isCollection != false ? valueType : value.getClass();
                    try {
                        setterM = valueType.getMethod("set" + this.getMethodNameSuffix(setter), new Class[]{classType});
                        objectValue = isCollection == false ? value : this.getCollectionSingleton(valueType, value);
                        setterM.invoke(ownerBean, new Object[]{objectValue});
                        castedValue = objectValue;
                    }
                    catch (Throwable ex) {
                        throw new SearchParseException("Cannot convert String value \"" + value + "\" to a value of class " + valueType.getName(), ex);
                    }
                }
            }
lbl36:
            // 5 sources

            if (lastCastedValue != null) {
                castedValue = lastCastedValue;
            }
            return castedValue;
        }
        names = setter.split("\\.");
        try {
            nextPart = this.getMethodNameSuffix(names[1]);
            getterM = actualType.getMethod("get" + nextPart, new Class[0]);
            returnType = getterM.getReturnType();
            returnCollection = InjectionUtils.isSupportedCollectionOrArray(returnType);
            actualReturnType = returnCollection == false ? returnType : InjectionUtils.getActualType((Type)getterM.getGenericReturnType());
            isPrimitive = InjectionUtils.isPrimitive((Class)returnType) != false || returnType.isEnum() != false;
            v1 = lastTry = names.length == 2 && (isPrimitive != false || returnType == Date.class || returnCollection != false);
            v2 = ownerBean != null ? ownerBean : (valueObject = actualType.isInterface() != false ? Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{actualType}, (InvocationHandler)new InterfaceProxy()) : actualType.newInstance());
            if (lastTry) {
                if (!returnCollection) {
                    nextObject = isPrimitive != false ? InjectionUtils.convertStringToPrimitive((String)value, (Class)returnType) : this.convertToDate(value);
                } else {
                    collCheck = this.getCollectionCheck(originalPropName, true, actualReturnType);
                    if (collCheck == null) {
                        nextObject = this.getCollectionSingleton(valueType, value);
                    } else {
                        typeInfo.setCollectionCheckInfo(new CollectionCheckInfo(collCheck, value));
                        nextObject = this.getEmptyCollection(valueType);
                    }
                }
            } else {
                nextObject = returnType.newInstance();
            }
            setterM = actualType.getMethod("set" + nextPart, new Class[]{returnType});
            setterM.invoke(valueObject, new Object[]{nextObject});
            if (lastTry) {
                lastCastedValue = lastCastedValue == null ? valueObject : lastCastedValue;
                return isCollection != false ? this.getCollectionSingleton(valueType, lastCastedValue) : lastCastedValue;
            }
            lastCastedValue = valueObject;
            nextTypeInfo = new Beanspector.TypeInfo(nextObject.getClass(), getterM.getGenericReturnType());
            response = this.parseType(originalPropName, nextObject, lastCastedValue, setter.substring(index + 1), nextTypeInfo, value);
            if (ownerBean == null) {
                return isCollection != false ? this.getCollectionSingleton(valueType, lastCastedValue) : lastCastedValue;
            }
            return response;
        }
        catch (Throwable e) {
            throw new SearchParseException("Cannot convert String value \"" + value + "\" to a value of class " + valueType.getName(), e);
        }
    }

    private CollectionCheck getCollectionCheck(String propName, boolean isCollection, Class<?> actualCls) {
        if (isCollection) {
            if (InjectionUtils.isPrimitive(actualCls)) {
                if (propName.startsWith(EXTENSION_COUNT_OPEN)) {
                    return CollectionCheck.SIZE;
                }
            } else {
                return CollectionCheck.SIZE;
            }
        }
        return null;
    }

    private Object getCollectionSingleton(Class<?> collectionCls, Object value) {
        if (Set.class.isAssignableFrom(collectionCls)) {
            return Collections.singleton(value);
        }
        return Collections.singletonList(value);
    }

    private Object getEmptyCollection(Class<?> collectionCls) {
        if (Set.class.isAssignableFrom(collectionCls)) {
            return Collections.emptySet();
        }
        return Collections.emptyList();
    }

    private Object convertToDate(String value) throws SearchParseException {
        try {
            int idx;
            SimpleDateFormat df = SearchUtils.getDateFormat(this.contextProperties);
            String dateValue = value;
            if (SearchUtils.isTimeZoneSupported(this.contextProperties, Boolean.FALSE) && (idx = value.lastIndexOf(58)) != -1) {
                dateValue = value.substring(0, idx) + value.substring(idx + 1);
            }
            return df.parse(dateValue);
        }
        catch (ParseException e) {
            try {
                Date now = new Date();
                DatatypeFactory.newInstance().newDuration(value).addTo(now);
                return now;
            }
            catch (DatatypeConfigurationException e1) {
                throw new SearchParseException(e1);
            }
            catch (IllegalArgumentException e1) {
                throw new SearchParseException("Can parse " + value + " neither as date nor duration", e);
            }
        }
    }

    private int getDotIndex(String setter) {
        return this.conditionClass == SearchBean.class ? -1 : setter.indexOf(".");
    }

    private String getSetter(String setter) {
        int index = this.getDotIndex(setter);
        if (index != -1) {
            return setter.substring(0, index).toLowerCase();
        }
        return setter;
    }

    private String unwrapSetter(String setter) {
        if (setter.startsWith(EXTENSION_COUNT_OPEN) && setter.endsWith(")")) {
            return setter.substring(EXTENSION_COUNT_OPEN.length(), setter.length() - 1);
        }
        return setter;
    }

    private String getMethodNameSuffix(String name) {
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    static {
        OPERATORS_MAP = new HashMap<String, ConditionType>();
        OPERATORS_MAP.put(GT, ConditionType.GREATER_THAN);
        OPERATORS_MAP.put(GE, ConditionType.GREATER_OR_EQUALS);
        OPERATORS_MAP.put(LT, ConditionType.LESS_THAN);
        OPERATORS_MAP.put(LE, ConditionType.LESS_OR_EQUALS);
        OPERATORS_MAP.put(EQ, ConditionType.EQUALS);
        OPERATORS_MAP.put(NEQ, ConditionType.NOT_EQUALS);
        CONDITION_MAP = new HashMap<ConditionType, String>();
        CONDITION_MAP.put(ConditionType.GREATER_THAN, GT);
        CONDITION_MAP.put(ConditionType.GREATER_OR_EQUALS, GE);
        CONDITION_MAP.put(ConditionType.LESS_THAN, LT);
        CONDITION_MAP.put(ConditionType.LESS_OR_EQUALS, LE);
        CONDITION_MAP.put(ConditionType.EQUALS, EQ);
        CONDITION_MAP.put(ConditionType.NOT_EQUALS, NEQ);
        String comparators = "=gt=|=ge=|=lt=|=le=|==|!=";
        String s1 = "[\\p{ASCII}]+(" + comparators + ")";
        COMPARATORS_PATTERN = Pattern.compile(s1);
        String s2 = "[\\p{ASCII}]+(" + comparators + "|" + "=" + ")";
        COMPARATORS_PATTERN_SINGLE_EQUALS = Pattern.compile(s2);
    }

    static class TypeInfoObject {
        private Object object;
        private Beanspector.TypeInfo typeInfo;

        public TypeInfoObject(Object object, Beanspector.TypeInfo typeInfo) {
            this.object = object;
            this.typeInfo = typeInfo;
        }

        public Beanspector.TypeInfo getTypeInfo() {
            return this.typeInfo;
        }

        public Object getObject() {
            return this.object;
        }
    }

    private class Comparison
    implements ASTNode<T> {
        private String name;
        private String operator;
        private TypeInfoObject tvalue;

        public Comparison(String name, String operator, TypeInfoObject value) {
            this.name = name;
            this.operator = operator;
            this.tvalue = value;
        }

        public String toString() {
            return this.name + " " + this.operator + " " + this.tvalue.getObject() + " (" + this.tvalue.getObject().getClass().getSimpleName() + ")";
        }

        @Override
        public SearchCondition<T> build() throws SearchParseException {
            String templateName = FiqlParser.this.getSetter(this.name);
            Object cond = this.createTemplate(templateName);
            ConditionType ct = (ConditionType)((Object)FiqlParser.this.operatorsMap.get(this.operator));
            if (this.isPrimitive(cond)) {
                return new SimpleSearchCondition(ct, cond);
            }
            String templateNameLCase = templateName.toLowerCase();
            return new SimpleSearchCondition(Collections.singletonMap(templateNameLCase, ct), Collections.singletonMap(templateNameLCase, this.name), Collections.singletonMap(templateNameLCase, this.tvalue.getTypeInfo()), cond);
        }

        private boolean isPrimitive(T pojo) {
            return pojo.getClass().getName().startsWith("java.lang");
        }

        private T createTemplate(String setter) throws SearchParseException {
            try {
                if (FiqlParser.this.beanspector != null) {
                    FiqlParser.this.beanspector.instantiate().setValue(setter, this.tvalue.getObject());
                    return FiqlParser.this.beanspector.getBean();
                }
                SearchBean bean = (SearchBean)FiqlParser.this.conditionClass.newInstance();
                bean.set(setter, this.tvalue.getObject().toString());
                return bean;
            }
            catch (Throwable e) {
                throw new SearchParseException(e);
            }
        }
    }

    private class SubExpression
    implements ASTNode<T> {
        private String operator;
        private List<ASTNode<T>> subnodes = new ArrayList();

        public SubExpression(String operator) {
            this.operator = operator;
        }

        public void add(ASTNode<T> node) {
            this.subnodes.add(node);
        }

        public List<ASTNode<T>> getSubnodes() {
            return Collections.unmodifiableList(this.subnodes);
        }

        public String toString() {
            String s = this.operator.equals(FiqlParser.AND) ? "AND" : "OR";
            StringBuilder builder = new StringBuilder(s);
            builder.append(":[");
            for (int i = 0; i < this.subnodes.size(); ++i) {
                builder.append(this.subnodes.get(i));
                if (i >= this.subnodes.size() - 1) continue;
                builder.append(", ");
            }
            builder.append("]");
            return builder.toString();
        }

        @Override
        public SearchCondition<T> build() throws SearchParseException {
            ArrayList scNodes = new ArrayList();
            for (ASTNode node : this.subnodes) {
                scNodes.add(node.build());
            }
            if (FiqlParser.OR.equals(this.operator)) {
                return new OrSearchCondition(scNodes);
            }
            return new AndSearchCondition(scNodes);
        }
    }

    private static interface ASTNode<T> {
        public SearchCondition<T> build() throws SearchParseException;
    }
}

