/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.spec.IvParameterSpec;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwe.AbstractContentEncryptionCipherProperties;
import org.apache.cxf.rs.security.jose.jwe.AbstractJweDecryption;
import org.apache.cxf.rs.security.jose.jwe.AesCbcHmacJweEncryption;
import org.apache.cxf.rs.security.jose.jwe.ContentDecryptionAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.KeyDecryptionAlgorithm;

public class AesCbcHmacJweDecryption
extends AbstractJweDecryption {
    private String supportedAlgo;

    public AesCbcHmacJweDecryption(KeyDecryptionAlgorithm keyDecryptionAlgo) {
        this(keyDecryptionAlgo, (String)null);
    }

    public AesCbcHmacJweDecryption(KeyDecryptionAlgorithm keyDecryptionAlgo, String supportedAlgo) {
        super(keyDecryptionAlgo, new AesCbcContentDecryptionAlgorithm(supportedAlgo));
        this.supportedAlgo = supportedAlgo;
    }

    @Override
    protected JweDecryptionOutput doDecrypt(JweDecryptionInput jweDecryptionInput, byte[] cek) {
        this.validateAuthenticationTag(jweDecryptionInput, cek);
        return super.doDecrypt(jweDecryptionInput, cek);
    }

    @Override
    protected byte[] getActualCek(byte[] theCek, String algoJwt) {
        this.validateCekAlgorithm(algoJwt);
        return AesCbcHmacJweEncryption.doGetActualCek(theCek, algoJwt);
    }

    protected void validateAuthenticationTag(JweDecryptionInput jweDecryptionInput, byte[] theCek) {
        byte[] actualAuthTag = jweDecryptionInput.getAuthTag();
        AesCbcHmacJweEncryption.MacState macState = AesCbcHmacJweEncryption.getInitializedMacState(theCek, jweDecryptionInput.getInitVector(), jweDecryptionInput.getAad(), jweDecryptionInput.getJweHeaders(), jweDecryptionInput.getDecodedJsonHeaders());
        macState.mac.update(jweDecryptionInput.getEncryptedContent());
        byte[] expectedAuthTag = AesCbcHmacJweEncryption.signAndGetTag(macState);
        if (!Arrays.equals(actualAuthTag, expectedAuthTag)) {
            throw new SecurityException();
        }
    }

    private String validateCekAlgorithm(String cekAlgo) {
        if (!Algorithm.isAesCbcHmac(cekAlgo) || this.supportedAlgo != null && !this.supportedAlgo.equals(cekAlgo)) {
            throw new SecurityException();
        }
        return cekAlgo;
    }

    private static class AesCbcContentDecryptionAlgorithm
    extends AbstractContentEncryptionCipherProperties
    implements ContentDecryptionAlgorithm {
        public AesCbcContentDecryptionAlgorithm(String supportedAlgo) {
            super(supportedAlgo);
        }

        @Override
        public AlgorithmParameterSpec getAlgorithmParameterSpec(byte[] theIv) {
            return new IvParameterSpec(theIv);
        }

        @Override
        public byte[] getAdditionalAuthenticationData(String headersJson, byte[] aad) {
            return null;
        }

        @Override
        public byte[] getEncryptedSequence(JweHeaders headers, byte[] cipher, byte[] authTag) {
            return cipher;
        }
    }
}

