/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.Bus;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rs.security.jose.JoseHeaders;
import org.apache.cxf.rs.security.jose.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jwa.Algorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwk.JwkUtils;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.HmacJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.PublicKeyJwsSignatureVerifier;

public final class JwsUtils {
    private static final String JSON_WEB_SIGNATURE_ALGO_PROP = "rs.security.jws.content.signature.algorithm";
    private static final String RSSEC_SIGNATURE_OUT_PROPS = "rs.security.signature.out.properties";
    private static final String RSSEC_SIGNATURE_IN_PROPS = "rs.security.signature.in.properties";
    private static final String RSSEC_SIGNATURE_PROPS = "rs.security.signature.properties";
    private static final String JSON_WEB_SIGNATURE_REPORT_KEY_PROP = "rs.security.jws.report.public.key";

    private JwsUtils() {
    }

    public static String sign(RSAPrivateKey key, String algo, String content) {
        return JwsUtils.sign(key, algo, content, null);
    }

    public static String sign(RSAPrivateKey key, String algo, String content, String ct) {
        return JwsUtils.sign(JwsUtils.getRSAKeySignatureProvider(key, algo), content, ct);
    }

    public static String sign(byte[] key, String algo, String content) {
        return JwsUtils.sign(key, algo, content, null);
    }

    public static String sign(byte[] key, String algo, String content, String ct) {
        return JwsUtils.sign(JwsUtils.getHmacSignatureProvider(key, algo), content, ct);
    }

    public static String verify(RSAPublicKey key, String algo, String content) {
        JwsCompactConsumer jws = JwsUtils.verify(JwsUtils.getRSAKeySignatureVerifier(key, algo), content);
        return jws.getDecodedJwsPayload();
    }

    public static String verify(byte[] key, String algo, String content) {
        JwsCompactConsumer jws = JwsUtils.verify(JwsUtils.getHmacSignatureVerifier(key, algo), content);
        return jws.getDecodedJwsPayload();
    }

    public static JwsSignatureProvider getSignatureProvider(JsonWebKey jwk) {
        return JwsUtils.getSignatureProvider(jwk, null);
    }

    public static JwsSignatureProvider getSignatureProvider(JsonWebKey jwk, String defaultAlgorithm) {
        String rsaSignatureAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        JwsSignatureProvider theSigProvider = null;
        if ("RSA".equals(jwk.getKeyType())) {
            theSigProvider = JwsUtils.getRSAKeySignatureProvider(JwkUtils.toRSAPrivateKey(jwk), rsaSignatureAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            byte[] key = JoseUtils.decode((String)jwk.getProperty("k"));
            theSigProvider = JwsUtils.getHmacSignatureProvider(key, rsaSignatureAlgo);
        } else if ("EC".equals(jwk.getKeyType())) {
            theSigProvider = new EcDsaJwsSignatureProvider(JwkUtils.toECPrivateKey(jwk), rsaSignatureAlgo);
        }
        return theSigProvider;
    }

    public static JwsSignatureProvider getRSAKeySignatureProvider(RSAPrivateKey key, String algo) {
        return new PrivateKeyJwsSignatureProvider(key, algo);
    }

    public static JwsSignatureProvider getHmacSignatureProvider(byte[] key, String algo) {
        if (Algorithm.isHmacSign(algo)) {
            return new HmacJwsSignatureProvider(key, algo);
        }
        return null;
    }

    public static JwsSignatureVerifier getSignatureVerifier(JsonWebKey jwk) {
        return JwsUtils.getSignatureVerifier(jwk, null);
    }

    public static JwsSignatureVerifier getSignatureVerifier(JsonWebKey jwk, String defaultAlgorithm) {
        String rsaSignatureAlgo = jwk.getAlgorithm() == null ? defaultAlgorithm : jwk.getAlgorithm();
        JwsSignatureVerifier theVerifier = null;
        if ("RSA".equals(jwk.getKeyType())) {
            theVerifier = JwsUtils.getRSAKeySignatureVerifier(JwkUtils.toRSAPublicKey(jwk, true), rsaSignatureAlgo);
        } else if ("oct".equals(jwk.getKeyType())) {
            byte[] key = JoseUtils.decode((String)jwk.getProperty("k"));
            theVerifier = JwsUtils.getHmacSignatureVerifier(key, rsaSignatureAlgo);
        } else if ("EC".equals(jwk.getKeyType())) {
            theVerifier = new EcDsaJwsSignatureVerifier(JwkUtils.toECPublicKey(jwk), rsaSignatureAlgo);
        }
        return theVerifier;
    }

    public static JwsSignatureVerifier getRSAKeySignatureVerifier(RSAPublicKey key, String algo) {
        return new PublicKeyJwsSignatureVerifier(key, algo);
    }

    public static JwsSignatureVerifier getHmacSignatureVerifier(byte[] key, String algo) {
        if (Algorithm.isHmacSign(algo)) {
            return new HmacJwsSignatureVerifier(key, algo);
        }
        return null;
    }

    public static MultivaluedMap<String, JwsJsonSignatureEntry> getJwsJsonSignatureMap(List<JwsJsonSignatureEntry> signatures) {
        MetadataMap map = new MetadataMap();
        for (JwsJsonSignatureEntry entry : signatures) {
            map.add((Object)entry.getUnionHeader().getAlgorithm(), (Object)entry);
        }
        return map;
    }

    public static JwsSignatureProvider loadSignatureProvider(boolean required) {
        return JwsUtils.loadSignatureProvider(null, required);
    }

    public static JwsSignatureProvider loadSignatureProvider(JoseHeaders headers, boolean required) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, required, RSSEC_SIGNATURE_OUT_PROPS, RSSEC_SIGNATURE_PROPS);
        if (props == null) {
            return null;
        }
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider(m, props, headers, false);
        if (headers != null) {
            headers.setAlgorithm(theSigProvider.getAlgorithm());
        }
        return theSigProvider;
    }

    public static JwsSignatureVerifier loadSignatureVerifier(boolean required) {
        return JwsUtils.loadSignatureVerifier(null, required);
    }

    public static JwsSignatureVerifier loadSignatureVerifier(JoseHeaders headers, boolean required) {
        Message m = JAXRSUtils.getCurrentMessage();
        Properties props = KeyManagementUtils.loadStoreProperties(m, required, RSSEC_SIGNATURE_IN_PROPS, RSSEC_SIGNATURE_PROPS);
        if (props == null) {
            return null;
        }
        return JwsUtils.loadSignatureVerifier(m, props, headers, false);
    }

    public static List<JwsSignatureProvider> loadSignatureProviders(String propLoc, Message m) {
        List<JsonWebKey> jwks;
        Properties props = JwsUtils.loadProperties(m, propLoc);
        JwsSignatureProvider theSigProvider = JwsUtils.loadSignatureProvider(m, props, null, true);
        if (theSigProvider != null) {
            return Collections.singletonList(theSigProvider);
        }
        ArrayList<JwsSignatureProvider> theSigProviders = null;
        if ("jwk".equals(props.get("rs.security.keystore.type")) && (jwks = JwkUtils.loadJsonWebKeys(m, props, "sign")) != null) {
            theSigProviders = new ArrayList<JwsSignatureProvider>(jwks.size());
            for (JsonWebKey jwk : jwks) {
                theSigProviders.add(JwsUtils.getSignatureProvider(jwk));
            }
        }
        if (theSigProviders == null) {
            throw new SecurityException();
        }
        return theSigProviders;
    }

    public static List<JwsSignatureVerifier> loadSignatureVerifiers(String propLoc, Message m) {
        List<JsonWebKey> jwks;
        Properties props = JwsUtils.loadProperties(m, propLoc);
        JwsSignatureVerifier theVerifier = JwsUtils.loadSignatureVerifier(m, props, null, true);
        if (theVerifier != null) {
            return Collections.singletonList(theVerifier);
        }
        ArrayList<JwsSignatureVerifier> theVerifiers = null;
        if ("jwk".equals(props.get("rs.security.keystore.type")) && (jwks = JwkUtils.loadJsonWebKeys(m, props, "verify")) != null) {
            theVerifiers = new ArrayList<JwsSignatureVerifier>(jwks.size());
            for (JsonWebKey jwk : jwks) {
                theVerifiers.add(JwsUtils.getSignatureVerifier(jwk));
            }
        }
        if (theVerifiers == null) {
            throw new SecurityException();
        }
        return theVerifiers;
    }

    public static boolean validateCriticalHeaders(JoseHeaders headers) {
        return JoseUtils.validateCriticalHeaders(headers);
    }

    private static JwsSignatureProvider loadSignatureProvider(Message m, Properties props, JoseHeaders headers, boolean ignoreNullProvider) {
        boolean reportPublicKey;
        JwsSignatureProvider theSigProvider = null;
        String rsaSignatureAlgo = null;
        boolean bl = reportPublicKey = headers != null && MessageUtils.isTrue((Object)MessageUtils.getContextualProperty((Message)m, (String)JSON_WEB_SIGNATURE_REPORT_KEY_PROP, (String)"rs.security.report.public.key"));
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "sign");
            if (jwk != null) {
                rsaSignatureAlgo = JwsUtils.getSignatureAlgo(m, props, jwk.getAlgorithm(), JwsUtils.getDefaultKeyAlgo(jwk));
                theSigProvider = JwsUtils.getSignatureProvider(jwk, rsaSignatureAlgo);
                if (reportPublicKey) {
                    JwkUtils.setPublicKeyInfo(jwk, headers, rsaSignatureAlgo);
                }
            }
        } else {
            rsaSignatureAlgo = JwsUtils.getSignatureAlgo(m, props, null, null);
            RSAPrivateKey pk = KeyManagementUtils.loadPrivateKey(m, props, "sign");
            theSigProvider = JwsUtils.getRSAKeySignatureProvider(pk, rsaSignatureAlgo);
            if (reportPublicKey) {
                headers.setX509Chain(KeyManagementUtils.loadAndEncodeX509CertificateOrChain(m, props));
            }
        }
        if (theSigProvider == null && !ignoreNullProvider) {
            throw new SecurityException();
        }
        return theSigProvider;
    }

    private static JwsSignatureVerifier loadSignatureVerifier(Message m, Properties props, JoseHeaders inHeaders, boolean ignoreNullVerifier) {
        JwsSignatureVerifier theVerifier = null;
        if (inHeaders != null) {
            if (inHeaders.getHeader("jwk") != null) {
                JsonWebKey publicJwk = inHeaders.getJsonWebKey();
                return JwsUtils.getSignatureVerifier(publicJwk, inHeaders.getAlgorithm());
            }
            if (inHeaders.getHeader("x5c") != null) {
                List<X509Certificate> chain = KeyManagementUtils.toX509CertificateChain(inHeaders.getX509Chain());
                return JwsUtils.getRSAKeySignatureVerifier((RSAPublicKey)chain.get(0).getPublicKey(), inHeaders.getAlgorithm());
            }
        }
        String rsaSignatureAlgo = null;
        if ("jwk".equals(props.get("rs.security.keystore.type"))) {
            JsonWebKey jwk = JwkUtils.loadJsonWebKey(m, props, "verify");
            if (jwk != null) {
                rsaSignatureAlgo = JwsUtils.getSignatureAlgo(m, props, jwk.getAlgorithm(), JwsUtils.getDefaultKeyAlgo(jwk));
                theVerifier = JwsUtils.getSignatureVerifier(jwk, rsaSignatureAlgo);
            }
        } else {
            rsaSignatureAlgo = JwsUtils.getSignatureAlgo(m, props, null, null);
            theVerifier = JwsUtils.getRSAKeySignatureVerifier((RSAPublicKey)KeyManagementUtils.loadPublicKey(m, props), rsaSignatureAlgo);
        }
        if (theVerifier == null && !ignoreNullVerifier) {
            throw new SecurityException();
        }
        return theVerifier;
    }

    private static Properties loadProperties(Message m, String propLoc) {
        try {
            return ResourceUtils.loadProperties((String)propLoc, (Bus)m.getExchange().getBus());
        }
        catch (Exception ex) {
            throw new SecurityException(ex);
        }
    }

    private static String getSignatureAlgo(Message m, Properties props, String algo, String defaultAlgo) {
        if (algo == null) {
            if (defaultAlgo == null) {
                defaultAlgo = "RS256";
            }
            return KeyManagementUtils.getKeyAlgorithm(m, props, JSON_WEB_SIGNATURE_ALGO_PROP, defaultAlgo);
        }
        return algo;
    }

    private static String getDefaultKeyAlgo(JsonWebKey jwk) {
        if ("oct".equals(jwk.getKeyType())) {
            return "HS256";
        }
        if ("EC".equals(jwk.getKeyType())) {
            return "ES256";
        }
        return "RS256";
    }

    private static JwsCompactConsumer verify(JwsSignatureVerifier v, String content) {
        JwsCompactConsumer jws = new JwsCompactConsumer(content);
        if (!jws.verifySignatureWith(v)) {
            throw new SecurityException();
        }
        return jws;
    }

    private static String sign(JwsSignatureProvider jwsSig, String content, String ct) {
        JoseHeaders headers = new JoseHeaders();
        if (ct != null) {
            headers.setContentType(ct);
        }
        JwsCompactProducer jws = new JwsCompactProducer(headers, content);
        jws.signWith(jwsSig);
        return jws.getSignedEncodedJws();
    }
}

