/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.client;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContext;
import org.apache.cxf.rs.security.oauth2.client.ClientTokenContextManager;

public class MemoryClientTokenContextManager
implements ClientTokenContextManager {
    private ConcurrentHashMap<String, ClientTokenContext> map = new ConcurrentHashMap();

    @Override
    public void setClientTokenContext(MessageContext mc, ClientTokenContext request) {
        this.map.put(this.getKey(mc), request);
    }

    private String getKey(MessageContext mc) {
        return mc.getSecurityContext().getUserPrincipal().getName();
    }

    @Override
    public ClientTokenContext getClientTokenContext(MessageContext mc) {
        return this.map.remove(this.getKey(mc));
    }

    @Override
    public void removeClientTokenContext(MessageContext mc, ClientTokenContext request) {
        this.map.remove(this.getKey(mc));
    }
}

